/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.clt;

import java.io.IOException;
import joptsimple.OptionSet;
import org.spectrumauctions.sats.clt.Model;
import org.spectrumauctions.sats.clt.ModelOptionParser;
import org.spectrumauctions.sats.core.api.GSVMModelCreator;
import org.spectrumauctions.sats.core.api.IllegalConfigException;
import org.spectrumauctions.sats.core.api.PathResult;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;

public class GSVMModelOptionParser
extends ModelOptionParser {
    public static final String KEY_NATIONALBIDDERS = "nationalb";
    public static final String KEY_REGIONALBIDDERS = "regionalb";

    public GSVMModelOptionParser() {
        this.accepts(KEY_NATIONALBIDDERS, "The number of National Bidders in the GSVM").withRequiredArg().ofType(Integer.class);
        this.accepts(KEY_REGIONALBIDDERS, "The number of Regional Bidders in the GSVM").withRequiredArg().ofType(Integer.class);
    }

    @Override
    protected Model getModel() {
        return Model.GSVM;
    }

    @Override
    public PathResult treatResult(String[] args) throws IllegalConfigException, UnsupportedBiddingLanguageException, IOException {
        GSVMModelCreator.Builder builder = new GSVMModelCreator.Builder();
        OptionSet options = this.parse(args);
        if (options.has(KEY_NATIONALBIDDERS)) {
            builder.setNumberOfNationalBidders((Integer)options.valueOf(KEY_NATIONALBIDDERS));
        }
        if (options.has(KEY_REGIONALBIDDERS)) {
            builder.setNumberOfRegionalBidders((Integer)options.valueOf(KEY_REGIONALBIDDERS));
        }
        return this.allModelsResultTreating(options, builder);
    }
}

