/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.clt;

import java.io.IOException;
import joptsimple.OptionSet;
import org.spectrumauctions.sats.clt.Model;
import org.spectrumauctions.sats.clt.ModelOptionParser;
import org.spectrumauctions.sats.core.api.IllegalConfigException;
import org.spectrumauctions.sats.core.api.MRVMModelCreator;
import org.spectrumauctions.sats.core.api.PathResult;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;

public class MRVMModelOptionParser
extends ModelOptionParser {
    public static final String KEY_LOCALBIDDERS = "localbidders";
    public static final String KEY_NATIONALBIDDERS = "nationalbidders";
    public static final String KEY_REGIONALBIDDERS = "regionalbidders";

    public MRVMModelOptionParser() {
        this.accepts(KEY_LOCALBIDDERS, "The number of Local Bidders in the MRVM Model").withRequiredArg().ofType(Integer.class);
        this.accepts(KEY_NATIONALBIDDERS, "The number of National Bidders in the MRVM Model").withRequiredArg().ofType(Integer.class);
        this.accepts(KEY_REGIONALBIDDERS, "The number of Regional Bidders in the MRVM Model").withRequiredArg().ofType(Integer.class);
    }

    @Override
    protected Model getModel() {
        return Model.MRVM;
    }

    @Override
    public PathResult treatResult(String[] args) throws IllegalConfigException, UnsupportedBiddingLanguageException, IOException {
        MRVMModelCreator.Builder builder = new MRVMModelCreator.Builder();
        OptionSet options = this.parse(args);
        if (options.has(KEY_NATIONALBIDDERS)) {
            builder.setNumberOfNationalBidders((Integer)options.valueOf(KEY_NATIONALBIDDERS));
        }
        if (options.has(KEY_REGIONALBIDDERS)) {
            builder.setNumberOfRegionalBidders((Integer)options.valueOf(KEY_REGIONALBIDDERS));
        }
        if (options.has(KEY_LOCALBIDDERS)) {
            builder.setNumberOfLocalBidders((Integer)options.valueOf(KEY_LOCALBIDDERS));
        }
        return this.allModelsResultTreating(options, builder);
    }
}

