/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.clt;

import java.io.IOException;
import joptsimple.OptionSet;
import org.spectrumauctions.sats.clt.Model;
import org.spectrumauctions.sats.clt.ModelOptionParser;
import org.spectrumauctions.sats.core.api.IllegalConfigException;
import org.spectrumauctions.sats.core.api.PathResult;
import org.spectrumauctions.sats.core.api.SRVMModelCreator;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;

public class SRVMModelOptionParser
extends ModelOptionParser {
    public static final String KEY_SMALLBIDDERS = "smallb";
    public static final String KEY_HIGHFREQUENCYBIDDERS = "highb";
    public static final String KEY_PRIMARYBIDDERS = "primaryb";
    public static final String KEY_SECONDARYBIDDERS = "secondaryb";

    public SRVMModelOptionParser() {
        this.accepts(KEY_SMALLBIDDERS, "The number of Small Bidders in the SRVM").withRequiredArg().ofType(Integer.class);
        this.accepts(KEY_HIGHFREQUENCYBIDDERS, "The number of High Frequency Bidders in the SRVM").withRequiredArg().ofType(Integer.class);
        this.accepts(KEY_PRIMARYBIDDERS, "The number of Primary Bidders in the SRVM").withRequiredArg().ofType(Integer.class);
        this.accepts(KEY_SECONDARYBIDDERS, "The number of Secondary Bidders in the SRVM").withRequiredArg().ofType(Integer.class);
    }

    @Override
    protected Model getModel() {
        return Model.SRVM;
    }

    @Override
    public PathResult treatResult(String[] args) throws IllegalConfigException, UnsupportedBiddingLanguageException, IOException {
        SRVMModelCreator.Builder builder = new SRVMModelCreator.Builder();
        OptionSet options = this.parse(args);
        if (options.has(KEY_SMALLBIDDERS)) {
            builder.setNumSmallBidders((Integer)options.valueOf(KEY_SMALLBIDDERS));
        }
        if (options.has(KEY_HIGHFREQUENCYBIDDERS)) {
            builder.setNumHighFrequencyBidders((Integer)options.valueOf(KEY_HIGHFREQUENCYBIDDERS));
        }
        if (options.has(KEY_PRIMARYBIDDERS)) {
            builder.setNumPrimaryBidders((Integer)options.valueOf(KEY_PRIMARYBIDDERS));
        }
        if (options.has(KEY_SECONDARYBIDDERS)) {
            builder.setNumSecondaryBidders((Integer)options.valueOf(KEY_SECONDARYBIDDERS));
        }
        return this.allModelsResultTreating(options, builder);
    }
}

