/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.api;

import java.io.File;
import java.io.IOException;
import org.spectrumauctions.sats.core.api.IllegalConfigException;
import org.spectrumauctions.sats.core.api.ModelCreator;
import org.spectrumauctions.sats.core.api.PathResult;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.gsvm.GSVMNationalBidderSetup;
import org.spectrumauctions.sats.core.model.gsvm.GSVMRegionalBidderSetup;
import org.spectrumauctions.sats.core.model.gsvm.GlobalSynergyValueModel;

public class GSVMModelCreator
extends ModelCreator {
    private final int numberOfNationalBidders;
    private final int numberOfReginalBidders;

    protected GSVMModelCreator(Builder builder) {
        super(builder);
        this.numberOfNationalBidders = builder.getNumberOfNationalBidders();
        this.numberOfReginalBidders = builder.getNumberOfRegionalBidders();
    }

    @Override
    public PathResult generateResult(File outputFolder) throws UnsupportedBiddingLanguageException, IOException, IllegalConfigException {
        GlobalSynergyValueModel model = new GlobalSynergyValueModel();
        model.setNumberOfNationalBidders(this.numberOfNationalBidders);
        model.setNumberOfRegionalBidders(this.numberOfReginalBidders);
        return this.appendTopLevelParamsAndSolve(model, outputFolder);
    }

    public static class Builder
    extends ModelCreator.Builder {
        private int numberOfNationalBidders = new GSVMNationalBidderSetup.Builder().getNumberOfBidders();
        private int numberOfRegionalBidders = new GSVMRegionalBidderSetup.Builder().getNumberOfBidders();

        @Override
        public GSVMModelCreator build() {
            return new GSVMModelCreator(this);
        }

        public int getNumberOfNationalBidders() {
            return this.numberOfNationalBidders;
        }

        public int getNumberOfRegionalBidders() {
            return this.numberOfRegionalBidders;
        }

        public void setNumberOfNationalBidders(int numberOfNationalBidders) {
            this.numberOfNationalBidders = numberOfNationalBidders;
        }

        public void setNumberOfRegionalBidders(int numberOfRegionalBidders) {
            this.numberOfRegionalBidders = numberOfRegionalBidders;
        }
    }
}

