/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.xor;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import org.spectrumauctions.sats.core.bidlang.xor.SizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.XORValue;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.Good;

public class DecreasingSizeOrderedXOR<T extends Good>
extends SizeOrderedXOR<T> {
    public DecreasingSizeOrderedXOR(Collection<T> goods, Bidder<T> bidder) {
        super(goods, bidder);
    }

    @Override
    public Iterator<XORValue<T>> iterator() {
        return new DecreasingIterator();
    }

    private class DecreasingIterator
    implements Iterator<XORValue<T>> {
        BigInteger minIndex = BigInteger.ZERO;
        BigInteger index;

        private DecreasingIterator() {
            this.index = BigInteger.valueOf(2L).pow(DecreasingSizeOrderedXOR.this.goods.size()).subtract(BigInteger.ONE);
        }

        @Override
        public boolean hasNext() {
            return this.index.compareTo(this.minIndex) > 0;
        }

        @Override
        public XORValue<T> next() {
            Bundle bundle = DecreasingSizeOrderedXOR.this.getBundle(this.index);
            this.index = this.index.subtract(BigInteger.ONE);
            return new XORValue(bundle, DecreasingSizeOrderedXOR.this.getValue(bundle));
        }
    }
}

