/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model;

import com.google.common.base.Preconditions;

public abstract class BidderSetup {
    protected final String setupName;
    protected final int numberOfBidders;

    protected BidderSetup(Builder builder) {
        this.setupName = builder.setupName;
        this.numberOfBidders = builder.numberOfBidders;
    }

    public String getSetupName() {
        return this.setupName;
    }

    public int getNumberOfBidders() {
        return this.numberOfBidders;
    }

    public static abstract class Builder {
        private String setupName;
        private int numberOfBidders;

        protected Builder(String setupName, int numberOfBidders) {
            this.setupName = setupName;
            this.numberOfBidders = numberOfBidders;
        }

        public String getSetupName() {
            return this.setupName;
        }

        public void setSetupName(String setupName) {
            Preconditions.checkNotNull((Object)setupName);
            this.setupName = setupName;
        }

        public int getNumberOfBidders() {
            return this.numberOfBidders;
        }

        public void setNumberOfBidders(int numberOfBidders) {
            Preconditions.checkArgument((numberOfBidders >= 0 ? 1 : 0) != 0);
            this.numberOfBidders = numberOfBidders;
        }

        public abstract BidderSetup build();
    }
}

