/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.bvm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class BMWorldSetup {
    protected final String setupName;
    protected final Map<String, Integer> bands;

    protected BMWorldSetup(BMWorldSetupBuilder builder) {
        this.bands = ImmutableMap.copyOf(builder.bands);
        this.setupName = builder.setupName;
    }

    public Map<String, Integer> bands() {
        return this.bands;
    }

    public String getSetupName() {
        return this.setupName;
    }

    public static abstract class BMWorldSetupBuilder {
        protected String setupName;
        protected Map<String, Integer> bands = new HashMap<String, Integer>();

        public BMWorldSetupBuilder(String setupName) {
            this.setupName = setupName;
        }

        public void addBand(String nameOfBand, int numberOfLicenses) {
            Preconditions.checkArgument((numberOfLicenses > 0 ? 1 : 0) != 0);
            this.bands.put(nameOfBand, numberOfLicenses);
        }

        public boolean removeBand(String nameOfBand) {
            return this.bands.remove(nameOfBand) != null;
        }

        public Map<String, Integer> getBands() {
            return Collections.unmodifiableMap(this.bands);
        }

        public String getSetupName() {
            return this.setupName;
        }

        public void setSetupName(String setupName) {
            this.setupName = setupName;
        }

        public abstract BMWorldSetup build();
    }
}

