/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.gsvm;

import java.math.BigDecimal;
import java.util.HashMap;
import org.spectrumauctions.sats.core.model.gsvm.GSVMBidder;
import org.spectrumauctions.sats.core.model.gsvm.GSVMBidderSetup;
import org.spectrumauctions.sats.core.model.gsvm.GSVMLicense;
import org.spectrumauctions.sats.core.model.gsvm.GSVMWorld;
import org.spectrumauctions.sats.core.util.random.DoubleInterval;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public class GSVMNationalBidderSetup
extends GSVMBidderSetup {
    private GSVMNationalBidderSetup(GSVMBidderSetup.Builder builder) {
        super(builder);
    }

    @Override
    HashMap<Long, BigDecimal> drawValues(RNGSupplier rngSupplier, GSVMBidder bidder) {
        UniformDistributionRNG rng = rngSupplier.getUniformDistributionRNG();
        GSVMWorld world = bidder.getWorld();
        HashMap<Long, BigDecimal> values = new HashMap<Long, BigDecimal>();
        for (GSVMLicense license : world.getNationalCircle().getLicenses()) {
            values.put(license.getId(), this.getValueDependingOnRegion(rng, license.getPosition(), world.getSize()));
        }
        return values;
    }

    public static class Builder
    extends GSVMBidderSetup.Builder {
        public Builder() {
            super("National Bidder Setup", 1, new DoubleInterval(0.0, 10.0), new DoubleInterval(0.0, 20.0), new DoubleInterval(0.0, 0.0));
        }

        @Override
        public GSVMNationalBidderSetup build() {
            return new GSVMNationalBidderSetup(this);
        }
    }
}

