/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.lsvm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.bidlang.xor.DecreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.IncreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.SizeBasedUniqueRandomXOR;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.lsvm.LSVMBidderSetup;
import org.spectrumauctions.sats.core.model.lsvm.LSVMLicense;
import org.spectrumauctions.sats.core.model.lsvm.LSVMWorld;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public final class LSVMBidder
extends Bidder<LSVMLicense> {
    private static final long serialVersionUID = -1774118565772856391L;
    private final int LSVM_A;
    private final int LSVM_B;
    private final Set<LSVMLicense> proximity;
    private final HashMap<Long, BigDecimal> values;
    private transient LSVMWorld world;

    LSVMBidder(LSVMBidderSetup setup, LSVMWorld world, long currentId, long population, RNGSupplier rngSupplier) {
        super(setup, population, currentId, world.getId());
        this.world = world;
        LSVMLicense favorite = setup.drawFavorite(rngSupplier, world);
        this.proximity = setup.getProximitySize() == -1 ? world.getGrid().getLicenses() : world.getGrid().getProximity(favorite, setup.getProximitySize());
        this.values = setup.drawValues(rngSupplier, this);
        this.LSVM_A = setup.getLsvmA();
        this.LSVM_B = setup.getLsvmB();
        this.store();
    }

    public ImmutableSet<LSVMLicense> getProximity() {
        return ImmutableSet.copyOf(this.proximity);
    }

    @Override
    public BigDecimal calculateValue(Bundle<LSVMLicense> bundle) {
        double value = 0.0;
        Set<Set<LSVMLicense>> subpackages = this.world.getGrid().getMaximallyConnectedSubpackages(bundle);
        for (Set<LSVMLicense> subset : subpackages) {
            double factor = this.calculateFactor(subset.size());
            value += factor * this.sumOfItemValues(subset);
        }
        return new BigDecimal(value);
    }

    private double sumOfItemValues(Set<LSVMLicense> subset) {
        double value = 0.0;
        for (LSVMLicense license : subset) {
            if (!this.values.containsKey(license.getId())) continue;
            value += this.values.get(license.getId()).doubleValue();
        }
        return value;
    }

    @Override
    public <T extends BiddingLanguage> T getValueFunction(Class<T> clazz, RNGSupplier rngSupplier) throws UnsupportedBiddingLanguageException {
        if (clazz.isAssignableFrom(SizeBasedUniqueRandomXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new SizeBasedUniqueRandomXOR<LSVMLicense>((Collection<LSVMLicense>)this.world.getLicenses(), rngSupplier, this)));
        }
        if (clazz.isAssignableFrom(IncreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new IncreasingSizeOrderedXOR<LSVMLicense>((Collection<LSVMLicense>)this.world.getLicenses(), this)));
        }
        if (clazz.isAssignableFrom(DecreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new DecreasingSizeOrderedXOR<LSVMLicense>((Collection<LSVMLicense>)this.world.getLicenses(), this)));
        }
        throw new UnsupportedBiddingLanguageException();
    }

    @Override
    public LSVMWorld getWorld() {
        return this.world;
    }

    @Override
    public void refreshReference(World world) {
        Preconditions.checkArgument((world.getId() == this.getWorldId() ? 1 : 0) != 0);
        if (!(world instanceof LSVMWorld)) {
            throw new IllegalArgumentException("World is not of correct type");
        }
        this.world = (LSVMWorld)world;
    }

    @Override
    public Bidder<LSVMLicense> drawSimilarBidder(RNGSupplier rngSupplier) {
        return new LSVMBidder((LSVMBidderSetup)this.getSetup(), this.getWorld(), this.getId(), this.getPopulation(), rngSupplier);
    }

    public Map<Long, BigDecimal> getBaseValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public double calculateFactor(int size) {
        return 1.0 + (double)this.LSVM_A / (100.0 * (1.0 + Math.exp(this.LSVM_B - size)));
    }
}

