/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import java.util.ArrayList;
import java.util.List;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.IncompatibleWorldException;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBand;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;

public class MRVMLicense
extends Good {
    private static final long serialVersionUID = 2814831255330638720L;
    private final String bandName;
    private transient MRVMBand band;
    private transient MRVMWorld world;
    private final int regionId;
    private transient MRVMRegionsMap.Region region;

    public static List<MRVMLicense> createLicenses(MRVMBand band, int startId, MRVMRegionsMap regionsMap) {
        ArrayList<MRVMLicense> licenses = new ArrayList<MRVMLicense>();
        for (int i = 0; i < band.getNumberOfLots(); ++i) {
            for (MRVMRegionsMap.Region region : regionsMap.getRegions()) {
                MRVMLicense license = new MRVMLicense(startId++, band, region);
                licenses.add(license);
            }
        }
        return licenses;
    }

    private MRVMLicense(long id, MRVMBand band, MRVMRegionsMap.Region region) {
        super(id, band.getWorldId());
        this.band = band;
        this.bandName = band.getName();
        this.world = band.getWorld();
        this.regionId = region.getId();
        this.region = region;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bandName == null ? 0 : this.bandName.hashCode());
        result = 31 * result + this.regionId;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MRVMLicense other = (MRVMLicense)obj;
        if (this.bandName == null ? other.bandName != null : !this.bandName.equals(other.bandName)) {
            return false;
        }
        return this.regionId == other.regionId;
    }

    @Override
    public MRVMWorld getWorld() {
        return this.world;
    }

    public static long getSerialversionuid() {
        return 2814831255330638720L;
    }

    public String getBandName() {
        return this.bandName;
    }

    public MRVMBand getBand() {
        return this.band;
    }

    @Override
    public long getWorldId() {
        return this.worldId;
    }

    public int getRegionId() {
        return this.regionId;
    }

    public MRVMRegionsMap.Region getRegion() {
        return this.region;
    }

    private void setBand(MRVMBand band) {
        if (!this.getBandName().equals(band.getName())) {
            throw new IncompatibleWorldException("The stored worldId does not represent the passed world reference");
        }
        this.band = band;
    }

    public void refreshFieldBackReferences(MRVMBand band) {
        this.setBand(band);
        this.world = band.getWorld();
        this.region = this.world.getRegionsMap().getRegion(this.regionId);
    }
}

