/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLicense;
import org.spectrumauctions.sats.core.model.mrvm.MRVMNationalBidderSetup;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.core.util.BigDecimalUtils;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public final class MRVMNationalBidder
extends MRVMBidder {
    private static final long serialVersionUID = 6947670485542817609L;
    private final SortedMap<Integer, BigDecimal> gammaValues;

    MRVMNationalBidder(long id, long populationId, MRVMWorld world, MRVMNationalBidderSetup setup, UniformDistributionRNG rng) {
        super(id, populationId, world, setup, rng);
        Map<Integer, BigDecimal> gammaInput = setup.drawGamma(world, rng);
        this.gammaValues = new TreeMap<Integer, BigDecimal>((SortedMap<Integer, BigDecimal>)MRVMNationalBidder.buildGammaMap(gammaInput));
        this.store();
    }

    private static ImmutableSortedMap<Integer, BigDecimal> buildGammaMap(Map<Integer, BigDecimal> gammaInput) {
        ImmutableSortedMap.Builder mapBuilder = ImmutableSortedMap.naturalOrder();
        TreeMap<Integer, BigDecimal> sortedInput = new TreeMap<Integer, BigDecimal>(gammaInput);
        Preconditions.checkArgument(((Integer)sortedInput.firstKey() == 1 ? 1 : 0) != 0, (String)"Gamma Values must (exclusively) be specified for quantities 1 and (optionally) higher", (Object[])new Object[]{sortedInput});
        Preconditions.checkArgument((boolean)((Integer)sortedInput.lastKey()).equals(sortedInput.size()), (String)"Gamma Values must be specified for all capacities in {0, ..., k_{max}}, where k_{max} > 0 is any natural number > 0", (Object[])new Object[]{sortedInput});
        for (Map.Entry inputGammaEntry : sortedInput.entrySet()) {
            Preconditions.checkArgument((((BigDecimal)inputGammaEntry.getValue()).compareTo(BigDecimal.ZERO) >= 0 ? 1 : 0) != 0, (String)"Gamma must not be negative", (Object[])new Object[]{inputGammaEntry});
            mapBuilder.put(inputGammaEntry);
        }
        return mapBuilder.build();
    }

    @Override
    public BigDecimal gammaFactor(MRVMRegionsMap.Region r, Bundle<MRVMLicense> bundle) {
        int uncoveredRegions = this.countUncoveredRegions(bundle);
        BigDecimal gamma = this.getGamma(uncoveredRegions);
        return gamma;
    }

    @Override
    public Map<MRVMRegionsMap.Region, BigDecimal> gammaFactors(Bundle<MRVMLicense> bundle) {
        BigDecimal gamma = this.gammaFactor(null, bundle);
        HashMap<MRVMRegionsMap.Region, BigDecimal> result = new HashMap<MRVMRegionsMap.Region, BigDecimal>();
        for (MRVMRegionsMap.Region region : this.getWorld().getRegionsMap().getRegions()) {
            result.put(region, gamma);
        }
        return result;
    }

    public int getKMax() {
        return this.gammaValues.lastKey();
    }

    private int countUncoveredRegions(Bundle<MRVMLicense> bundle) {
        Map<MRVMRegionsMap.Region, Bundle<MRVMLicense>> licensesPerRegion = MRVMWorld.getLicensesPerRegion(bundle);
        int uncoveredCount = 0;
        for (Bundle<MRVMLicense> regionalBundle : licensesPerRegion.values()) {
            if (!regionalBundle.isEmpty()) continue;
            ++uncoveredCount;
        }
        return uncoveredCount;
    }

    public BigDecimal getGamma(int uncoveredRegions) {
        if (uncoveredRegions > this.getKMax()) {
            uncoveredRegions = this.getKMax();
        } else if (uncoveredRegions == 0) {
            return BigDecimal.ONE;
        }
        return (BigDecimal)this.gammaValues.get(uncoveredRegions);
    }

    @Override
    public Bidder<MRVMLicense> drawSimilarBidder(RNGSupplier rngSupplier) {
        return new MRVMNationalBidder(this.getId(), this.getPopulation(), this.getWorld(), (MRVMNationalBidderSetup)this.getSetup(), rngSupplier.getUniformDistributionRNG());
    }

    @Override
    public <T extends BiddingLanguage> T getValueFunction(Class<T> type, RNGSupplier rngSupplier) throws UnsupportedBiddingLanguageException {
        return super.getValueFunction(type, rngSupplier);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.gammaValues == null ? 0 : BigDecimalUtils.hashCodeIgnoringScale(this.gammaValues));
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MRVMNationalBidder other = (MRVMNationalBidder)obj;
        return !(this.gammaValues == null ? other.gammaValues != null : !BigDecimalUtils.equalIgnoreScaleOnValues(this.gammaValues, other.gammaValues));
    }
}

