/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.srvm;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.srvm.SRVMBand;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidder;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidderSetup;
import org.spectrumauctions.sats.core.model.srvm.SRVMLicense;
import org.spectrumauctions.sats.core.model.srvm.SRVMWorldSetup;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public final class SRVMWorld
extends World {
    private static final long serialVersionUID = 1766287015715986936L;
    private final HashSet<SRVMBand> bands;
    private transient Integer numberOfGoods = null;
    private transient ImmutableSet<SRVMLicense> licenses = null;

    public SRVMWorld(SRVMWorldSetup setup, RNGSupplier rngSupplier) {
        super("Single-Region Value Model");
        this.bands = new HashSet<SRVMBand>(SRVMBand.createBands(this, setup, rngSupplier));
        this.store();
    }

    @Override
    public int getNumberOfGoods() {
        if (this.numberOfGoods == null) {
            int count = 0;
            for (SRVMBand band : this.bands) {
                count += band.getLicenses().size();
            }
            this.numberOfGoods = count;
        }
        return this.numberOfGoods;
    }

    public ImmutableSet<SRVMLicense> getLicenses() {
        if (this.licenses == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (SRVMBand band : this.bands) {
                builder.addAll(band.getLicenses());
            }
            this.licenses = builder.build();
        }
        return this.licenses;
    }

    public Set<SRVMBand> getBands() {
        return Collections.unmodifiableSet(this.bands);
    }

    public List<SRVMBidder> createPopulation(Collection<SRVMBidderSetup> bidderSetups, RNGSupplier rngSupplier) {
        long population = this.openNewPopulation();
        long currentId = 0L;
        ArrayList<SRVMBidder> bidders = new ArrayList<SRVMBidder>();
        for (SRVMBidderSetup setup : bidderSetups) {
            for (int i = 0; i < setup.getNumberOfBidders(); ++i) {
                bidders.add(new SRVMBidder(setup, this, currentId++, population, rngSupplier));
            }
        }
        return bidders;
    }

    public Collection<? extends Bidder<SRVMLicense>> restorePopulation(long populationId) {
        return super.restorePopulation(SRVMBidder.class, populationId);
    }

    @Override
    public void refreshFieldBackReferences() {
        for (SRVMBand band : this.bands) {
            band.refreshFieldBackReferences(this);
        }
    }
}

