/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.srvm;

import java.util.ArrayList;
import java.util.List;
import org.spectrumauctions.sats.core.model.DefaultModel;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidder;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidderSetup;
import org.spectrumauctions.sats.core.model.srvm.SRVMWorld;
import org.spectrumauctions.sats.core.model.srvm.SRVMWorldSetup;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public class SingleRegionModel
extends DefaultModel<SRVMWorld, SRVMBidder> {
    SRVMWorldSetup.Builder worldSetupBuilder = new SRVMWorldSetup.Builder();
    SRVMBidderSetup.SmallBidderBuilder smallBidderBuilder = new SRVMBidderSetup.SmallBidderBuilder();
    SRVMBidderSetup.HighFrequenceBidderBuilder highFrequencyBuilder = new SRVMBidderSetup.HighFrequenceBidderBuilder();
    SRVMBidderSetup.SecondaryBidderBuilder secondaryBidderBuilder = new SRVMBidderSetup.SecondaryBidderBuilder();
    SRVMBidderSetup.PrimaryBidderBuilder primaryBidderBuilder = new SRVMBidderSetup.PrimaryBidderBuilder();

    @Override
    public SRVMWorld createWorld(RNGSupplier worldSeed) {
        return new SRVMWorld(this.worldSetupBuilder.build(), worldSeed);
    }

    @Override
    public List<SRVMBidder> createPopulation(SRVMWorld world, RNGSupplier populationRNG) {
        ArrayList<SRVMBidderSetup> setups = new ArrayList<SRVMBidderSetup>();
        setups.add(this.smallBidderBuilder.build());
        setups.add(this.highFrequencyBuilder.build());
        setups.add(this.secondaryBidderBuilder.build());
        setups.add(this.primaryBidderBuilder.build());
        return world.createPopulation(setups, populationRNG);
    }

    public void setNumberOfSmallBidders(int numberOfBidders) {
        this.smallBidderBuilder.setNumberOfBidders(numberOfBidders);
    }

    public void setNumberOfHighFrequencyBidders(int numberOfBidders) {
        this.highFrequencyBuilder.setNumberOfBidders(numberOfBidders);
    }

    public void setNumberOfSecondaryBidders(int numberOfBidders) {
        this.secondaryBidderBuilder.setNumberOfBidders(numberOfBidders);
    }

    public void setNumberOfPrimaryBidders(int numberOfBidders) {
        this.primaryBidderBuilder.setNumberOfBidders(numberOfBidders);
    }
}

