/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.srvm;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeIncreasing;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeOrdered;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValueBidder;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.srvm.SRVMBand;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidder;
import org.spectrumauctions.sats.core.model.srvm.SRVMLicense;

public class SizeOrderedGenericFactory {
    static BandComparator comparator = new BandComparator();

    public static GenericSizeOrdered<SRVMBand, SRVMLicense> getSizeOrderedGenericLang(boolean increasing, SRVMBidder bidder) throws UnsupportedBiddingLanguageException {
        Set<SRVMBand> bands = bidder.getWorld().getBands();
        if (increasing) {
            return new Increasing(bands, bidder);
        }
        return new Decreasing(bands, bidder);
    }

    private static class BandComparator
    implements Comparator<SRVMBand>,
    Serializable {
        private static final long serialVersionUID = -7929466674087601381L;

        private BandComparator() {
        }

        @Override
        public int compare(SRVMBand o1, SRVMBand o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }

    private static final class Decreasing
    extends GenericSizeDecreasing<SRVMBand, SRVMLicense> {
        private final SRVMBidder bidder;

        protected Decreasing(Collection<SRVMBand> allPossibleGenericDefintions, SRVMBidder bidder) throws UnsupportedBiddingLanguageException {
            super(allPossibleGenericDefintions);
            this.bidder = bidder;
        }

        public SRVMBidder getBidder() {
            return this.bidder;
        }

        @Override
        protected GenericValueBidder<SRVMBand> getGenericBidder() {
            return this.bidder;
        }

        @Override
        protected Comparator<SRVMBand> getDefComparator() {
            return comparator;
        }
    }

    private static final class Increasing
    extends GenericSizeIncreasing<SRVMBand, SRVMLicense> {
        private final SRVMBidder bidder;

        protected Increasing(Collection<SRVMBand> allPossibleGenericDefintions, SRVMBidder bidder) throws UnsupportedBiddingLanguageException {
            super(allPossibleGenericDefintions);
            this.bidder = bidder;
        }

        public Bidder<SRVMLicense> getBidder() {
            return this.bidder;
        }

        @Override
        protected GenericValueBidder<SRVMBand> getGenericBidder() {
            return this.bidder;
        }

        @Override
        protected Comparator<SRVMBand> getDefComparator() {
            return comparator;
        }
    }
}

