/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.mechanism.cca;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spectrumauctions.sats.core.bidlang.xor.SizeBasedUniqueRandomXOR;
import org.spectrumauctions.sats.core.bidlang.xor.XORBid;
import org.spectrumauctions.sats.core.bidlang.xor.XORValue;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.IncompatibleWorldException;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.util.random.JavaUtilRNGSupplier;
import org.spectrumauctions.sats.mechanism.cca.CCAMechanism;
import org.spectrumauctions.sats.mechanism.cca.priceupdate.NonGenericPriceUpdater;
import org.spectrumauctions.sats.mechanism.cca.priceupdate.SimpleRelativeNonGenericPriceUpdate;
import org.spectrumauctions.sats.mechanism.cca.supplementaryround.NonGenericSupplementaryRound;
import org.spectrumauctions.sats.mechanism.cca.supplementaryround.ProfitMaximizingNonGenericSupplementaryRound;
import org.spectrumauctions.sats.mechanism.ccg.CCGMechanism;
import org.spectrumauctions.sats.mechanism.domain.MechanismResult;
import org.spectrumauctions.sats.mechanism.domain.mechanisms.AuctionMechanism;
import org.spectrumauctions.sats.mechanism.vcg.VCGMechanism;
import org.spectrumauctions.sats.opt.domain.Allocation;
import org.spectrumauctions.sats.opt.domain.NonGenericDemandQueryMIPBuilder;
import org.spectrumauctions.sats.opt.domain.NonGenericDemandQueryResult;
import org.spectrumauctions.sats.opt.xor.XORWinnerDetermination;

public class NonGenericCCAMechanism<T extends Good>
extends CCAMechanism<T> {
    private static final Logger logger = LogManager.getLogger(NonGenericCCAMechanism.class);
    private NonGenericDemandQueryMIPBuilder<T> demandQueryMIPBuilder;
    private Map<Good, BigDecimal> startingPrices = new HashMap<Good, BigDecimal>();
    private NonGenericPriceUpdater<T> priceUpdater = new SimpleRelativeNonGenericPriceUpdate();
    private List<NonGenericSupplementaryRound<T>> supplementaryRounds = new ArrayList<NonGenericSupplementaryRound<T>>();
    private Collection<XORBid<T>> bidsAfterClockPhase;
    private Collection<XORBid<T>> bidsAfterSupplementaryRound;
    private Map<T, BigDecimal> finalPrices;
    private Map<T, Integer> finalDemand;

    public NonGenericCCAMechanism(List<Bidder<T>> bidders, NonGenericDemandQueryMIPBuilder<T> nonGenericDemandQueryMIPBuilder) {
        super(bidders);
        this.demandQueryMIPBuilder = nonGenericDemandQueryMIPBuilder;
    }

    @Override
    public MechanismResult<T> getMechanismResult() {
        if (this.result != null) {
            return this.result;
        }
        if (this.bidsAfterClockPhase == null) {
            logger.info("Starting clock phase for XOR bids...");
            this.bidsAfterClockPhase = this.runClockPhase();
        }
        if (this.bidsAfterSupplementaryRound == null) {
            logger.info("Starting to collect bids for supplementary round...");
            this.bidsAfterSupplementaryRound = this.runSupplementaryRound();
        }
        logger.info("Starting to calculate payments with all collected bids...");
        this.result = this.calculatePayments();
        return this.result;
    }

    public void setStartingPrice(Good good, BigDecimal price) {
        this.startingPrices.put(good, price);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void calculateSampledStartingPrices(int bidsPerBidder, int numberOfWorldSamples, double fraction, long seed) {
        void var10_10;
        World world = this.bidders.stream().findAny().map(Bidder::getWorld).orElseThrow(NoSuchFieldError::new);
        HashMap<Good, SimpleRegression> regressions = new HashMap<Good, SimpleRegression>();
        for (Good good : world.getLicenses()) {
            SimpleRegression regression = new SimpleRegression();
            regression.addData(0.0, 0.0);
            regressions.put(good, regression);
        }
        JavaUtilRNGSupplier rngSupplier = new JavaUtilRNGSupplier(seed);
        boolean bl = false;
        while (var10_10 < numberOfWorldSamples) {
            List alternateBidders = this.bidders.stream().map(b -> b.drawSimilarBidder(rngSupplier)).collect(Collectors.toList());
            for (Bidder bidder : alternateBidders) {
                try {
                    SizeBasedUniqueRandomXOR valueFunction = bidder.getValueFunction(SizeBasedUniqueRandomXOR.class, rngSupplier);
                    valueFunction.setIterations(bidsPerBidder);
                    Iterator bidIterator = valueFunction.iterator();
                    while (bidIterator.hasNext()) {
                        XORValue bid = bidIterator.next();
                        Bundle bundle = bid.getLicenses();
                        BigDecimal value = bid.value();
                        for (Good good : bundle) {
                            double y = value.doubleValue() / (double)bundle.size();
                            ((SimpleRegression)regressions.get(good)).addData(1.0, y);
                        }
                    }
                }
                catch (UnsupportedBiddingLanguageException e) {
                    throw new RuntimeException(e);
                }
            }
            ++var10_10;
        }
        for (Map.Entry entry : regressions.entrySet()) {
            double y = ((SimpleRegression)entry.getValue()).predict(1.0);
            double price = y * fraction;
            logger.info("{}:\nFound y of {}, setting starting price to {}.", entry.getKey(), (Object)y, (Object)price);
            this.setStartingPrice((Good)entry.getKey(), BigDecimal.valueOf(price));
        }
    }

    public Allocation<T> calculateClockPhaseAllocation() {
        if (this.bidsAfterClockPhase == null) {
            logger.info("Starting clock phase for XOR bids...");
            this.bidsAfterClockPhase = this.runClockPhase();
        }
        HashSet<XORBid<T>> bids = new HashSet<XORBid<T>>(this.bidsAfterClockPhase);
        XORWinnerDetermination<T> wdp = new XORWinnerDetermination<T>(bids);
        return wdp.calculateAllocation();
    }

    public Allocation<T> calculateAllocationAfterSupplementaryRound() {
        if (this.bidsAfterClockPhase == null) {
            logger.info("Starting clock phase for XOR bids...");
            this.bidsAfterClockPhase = this.runClockPhase();
        }
        if (this.bidsAfterSupplementaryRound == null) {
            logger.info("Starting to collect bids for supplementary round...");
            this.bidsAfterSupplementaryRound = this.runSupplementaryRound();
        }
        HashSet<XORBid<T>> bids = new HashSet<XORBid<T>>(this.bidsAfterSupplementaryRound);
        XORWinnerDetermination<T> wdp = new XORWinnerDetermination<T>(bids);
        return wdp.calculateAllocation();
    }

    private Collection<XORBid<T>> runClockPhase() {
        boolean bl;
        HashMap bids = new HashMap();
        this.bidders.forEach(bidder -> bids.put((Bidder)bidder, new XORBid.Builder(bidder).build()));
        Map<Good, BigDecimal> prices = new HashMap<Good, BigDecimal>();
        for (Good good : ((Bidder)this.bidders.stream().findFirst().orElseThrow(IncompatibleWorldException::new)).getWorld().getLicenses()) {
            prices.put(good, this.startingPrices.getOrDefault(good, this.fallbackStartingPrice));
        }
        boolean bl2 = false;
        while (!bl) {
            HashMap<Good, BigDecimal> currentPrices = prices;
            HashMap<T, Integer> demand = new HashMap<T, Integer>();
            for (Bidder bidder2 : this.bidders) {
                List<NonGenericDemandQueryResult<T>> demandQueryResults = this.demandQueryMIPBuilder.getDemandQueryMipFor(bidder2, prices, this.epsilon).getResultPool(this.clockPhaseNumberOfBundles);
                Bundle<T> firstBundle = demandQueryResults.get(0).getResultingBundle().getLicenses();
                if (firstBundle.size() > 0) {
                    for (Good good : firstBundle) {
                        demand.put(good, demand.getOrDefault(good, 0) + 1);
                    }
                }
                for (NonGenericDemandQueryResult nonGenericDemandQueryResult : demandQueryResults) {
                    if (nonGenericDemandQueryResult.getResultingBundle().getLicenses().size() <= 0) continue;
                    Bundle bundle = nonGenericDemandQueryResult.getResultingBundle().getLicenses();
                    XORBid.Builder xorBidBuilder = new XORBid.Builder(bidder2, ((XORBid)bids.get(bidder2)).getValues());
                    BigDecimal bid = BigDecimal.valueOf(bundle.stream().mapToDouble(l -> ((BigDecimal)currentPrices.get(l)).doubleValue()).sum());
                    XORValue existing = xorBidBuilder.containsBundle(bundle);
                    if (existing != null && existing.value().compareTo(bid) < 1) {
                        xorBidBuilder.removeFromBid(existing);
                    }
                    if (existing == null || existing.value().compareTo(bid) < 0) {
                        xorBidBuilder.add(new XORValue(bundle, bid));
                    }
                    XORBid newBid = xorBidBuilder.build();
                    bids.put(bidder2, newBid);
                }
            }
            Map<T, BigDecimal> updatedPrices = this.priceUpdater.updatePrices(prices, demand);
            if (prices.equals(updatedPrices) || this.totalRounds >= this.maxRounds) {
                bl = true;
                this.finalDemand = demand;
                this.finalPrices = prices;
                continue;
            }
            prices = updatedPrices;
            ++this.totalRounds;
        }
        this.bidsAfterClockPhase = bids.values();
        return this.bidsAfterClockPhase;
    }

    private Collection<XORBid<T>> runSupplementaryRound() {
        HashSet<XORBid<T>> bids = new HashSet<XORBid<T>>();
        if (this.supplementaryRounds.isEmpty()) {
            this.supplementaryRounds.add(new ProfitMaximizingNonGenericSupplementaryRound());
        }
        for (Bidder bidder : this.bidders) {
            ArrayList newValues = new ArrayList();
            for (NonGenericSupplementaryRound<T> supplementaryRound : this.supplementaryRounds) {
                newValues.addAll(supplementaryRound.getSupplementaryBids(this, bidder));
            }
            XORBid bidderBid = this.bidsAfterClockPhase.stream().filter(bid -> bidder.equals(bid.getBidder())).findFirst().orElseThrow(NoSuchElementException::new);
            XORBid newBid = bidderBid.copyOfWithNewValues(newValues);
            bids.add(newBid);
        }
        this.bidsAfterSupplementaryRound = bids;
        return bids;
    }

    private MechanismResult<T> calculatePayments() {
        AuctionMechanism<T> mechanism;
        HashSet<XORBid<T>> bids = new HashSet<XORBid<T>>(this.bidsAfterSupplementaryRound);
        XORWinnerDetermination<T> wdp = new XORWinnerDetermination<T>(bids);
        switch (this.paymentRule) {
            case CCG: {
                mechanism = new CCGMechanism<T>(wdp);
                break;
            }
            default: {
                mechanism = new VCGMechanism<T>(wdp);
            }
        }
        this.result = mechanism.getMechanismResult();
        return this.result;
    }

    public int getSupplyMinusDemand() {
        World world = ((Bidder)this.bidders.iterator().next()).getWorld();
        Set<? extends Good> licenses = world.getLicenses();
        int aggregateDemand = 0;
        int supply = 0;
        for (Good good : licenses) {
            aggregateDemand += this.finalDemand.getOrDefault(good, 0).intValue();
            ++supply;
        }
        return supply - aggregateDemand;
    }

    public Collection<XORBid<T>> getBidsAfterClockPhase() {
        if (this.bidsAfterClockPhase == null) {
            this.runClockPhase();
        }
        return this.bidsAfterClockPhase;
    }

    public Collection<XORBid<T>> getBidsAfterSupplementaryRound() {
        if (this.bidsAfterClockPhase == null) {
            this.runClockPhase();
        }
        if (this.bidsAfterSupplementaryRound == null) {
            this.runSupplementaryRound();
        }
        return this.bidsAfterSupplementaryRound;
    }

    public Map<Bidder<T>, Integer> getXORBidsCount() {
        HashMap map = new HashMap();
        this.bidsAfterClockPhase.forEach(bid -> map.put(bid.getBidder(), bid.getValues().size()));
        return map;
    }

    public void setPriceUpdater(NonGenericPriceUpdater<T> nonGenericPriceUpdater) {
        Preconditions.checkArgument((this.bidsAfterClockPhase == null ? 1 : 0) != 0, (Object)"Already ran clock phase! Set the price updater before.");
        this.priceUpdater = nonGenericPriceUpdater;
    }

    public void addSupplementaryRound(NonGenericSupplementaryRound<T> nonGenericSupplementaryRound) {
        Preconditions.checkArgument((this.bidsAfterSupplementaryRound == null ? 1 : 0) != 0, (Object)"Already ran supplementary round!");
        this.supplementaryRounds.add(nonGenericSupplementaryRound);
    }

    public Map<Bidder<T>, Integer> getBidCountAfterClockPhase() {
        HashMap map = new HashMap();
        this.bidsAfterClockPhase.forEach(bid -> map.put(bid.getBidder(), bid.getValues().size()));
        return map;
    }

    public Map<Bidder<T>, Integer> getBidCountAfterSupplementaryRound() {
        HashMap map = new HashMap();
        this.bidsAfterSupplementaryRound.forEach(bid -> map.put(bid.getBidder(), bid.getValues().size()));
        return map;
    }

    public NonGenericDemandQueryMIPBuilder<T> getDemandQueryBuilder() {
        return this.demandQueryMIPBuilder;
    }

    public Map<T, BigDecimal> getFinalPrices() {
        return this.finalPrices;
    }

    public Map<T, BigDecimal> getLastPrices() {
        return this.priceUpdater.getLastPrices();
    }

    public XORBid<T> getBidAfterClockPhase(Bidder<T> bidder) {
        for (XORBid<T> bid : this.bidsAfterClockPhase) {
            if (!bid.getBidder().equals(bidder)) continue;
            return bid;
        }
        logger.warn("Couldn't find a bid for bidder {} after clock phase.", bidder);
        return null;
    }

    public XORBid<T> getBidAfterSupplementaryRound(Bidder<T> bidder) {
        for (XORBid<T> bid : this.bidsAfterSupplementaryRound) {
            if (!bid.getBidder().equals(bidder)) continue;
            return bid;
        }
        logger.warn("Couldn't find a bid for bidder {} after supplementary round.", bidder);
        return null;
    }
}

