/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.mechanism.cca.priceupdate;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.mechanism.cca.priceupdate.GenericPriceUpdater;

public class SimpleRelativeGenericPriceUpdate<G extends GenericDefinition<T>, T extends Good>
implements GenericPriceUpdater<G, T> {
    private static final BigDecimal DEFAULT_PRICE_UPDATE = BigDecimal.valueOf(0.1);
    private static final BigDecimal DEFAULT_INITIAL_UPDATE = BigDecimal.valueOf(100000.0);
    private BigDecimal priceUpdate = DEFAULT_PRICE_UPDATE;
    private BigDecimal initialUpdate = DEFAULT_INITIAL_UPDATE;
    private Map<G, BigDecimal> lastPrices = new HashMap<G, BigDecimal>();

    @Override
    public Map<G, BigDecimal> updatePrices(Map<G, BigDecimal> oldPrices, Map<G, Integer> demand) {
        if (this.lastPrices.isEmpty()) {
            for (Map.Entry<G, BigDecimal> oldPriceEntry : oldPrices.entrySet()) {
                this.lastPrices.put(oldPriceEntry.getKey(), oldPriceEntry.getValue());
            }
        }
        HashMap<GenericDefinition, BigDecimal> newPrices = new HashMap<GenericDefinition, BigDecimal>();
        for (Map.Entry<G, BigDecimal> oldPriceEntry : oldPrices.entrySet()) {
            GenericDefinition def = (GenericDefinition)oldPriceEntry.getKey();
            if (def.numberOfLicenses() < demand.getOrDefault(def, 0)) {
                this.lastPrices.put(def, oldPriceEntry.getValue());
                if (oldPriceEntry.getValue().equals(BigDecimal.ZERO)) {
                    newPrices.put(def, this.initialUpdate);
                    continue;
                }
                newPrices.put(def, oldPriceEntry.getValue().add(oldPriceEntry.getValue().multiply(this.priceUpdate)));
                continue;
            }
            newPrices.put(def, oldPriceEntry.getValue());
        }
        return newPrices;
    }

    @Override
    public Map<G, BigDecimal> getLastPrices() {
        return this.lastPrices;
    }

    public void setPriceUpdate(BigDecimal priceUpdate) {
        this.priceUpdate = priceUpdate;
    }

    public void setInitialUpdate(BigDecimal initialUpdate) {
        this.initialUpdate = initialUpdate;
    }

    public SimpleRelativeGenericPriceUpdate<G, T> withPriceUpdate(BigDecimal priceUpdate) {
        this.setPriceUpdate(priceUpdate);
        return this;
    }

    public SimpleRelativeGenericPriceUpdate<G, T> withInitialUpdate(BigDecimal initialUpdate) {
        this.setInitialUpdate(initialUpdate);
        return this;
    }
}

