/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.mechanism.cca.supplementaryround;

import java.util.ArrayList;
import java.util.List;
import org.spectrumauctions.sats.core.bidlang.xor.XORBid;
import org.spectrumauctions.sats.core.bidlang.xor.XORValue;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.mechanism.cca.NonGenericCCAMechanism;
import org.spectrumauctions.sats.mechanism.cca.supplementaryround.NonGenericSupplementaryRound;

public class LastBidsTrueValueNonGenericSupplementaryRound<T extends Good>
implements NonGenericSupplementaryRound<T> {
    private static final int DEFAULT_NUMBER_OF_SUPPLEMENTARY_BIDS = 500;
    private int numberOfSupplementaryBids = 500;

    @Override
    public List<XORValue<T>> getSupplementaryBids(NonGenericCCAMechanism<T> cca, Bidder<T> bidder) {
        XORBid<T> bid = cca.getBidAfterClockPhase(bidder);
        ArrayList<XORValue<T>> result = new ArrayList<XORValue<T>>();
        int count = 0;
        for (int i = bid.getValues().size() - 1; i >= 0 && count++ < this.numberOfSupplementaryBids; --i) {
            XORValue<T> value = bid.getValues().get(i);
            Bundle<T> licenses = new Bundle<T>(value.getLicenses());
            result.add(new XORValue<T>(licenses, bidder.calculateValue(licenses)));
        }
        return result;
    }

    public void setNumberOfSupplementaryBids(int numberOfSupplementaryBids) {
        this.numberOfSupplementaryBids = numberOfSupplementaryBids;
    }

    public LastBidsTrueValueNonGenericSupplementaryRound<T> withNumberOfSupplementaryBids(int numberOfSupplementaryBids) {
        this.numberOfSupplementaryBids = numberOfSupplementaryBids;
        return this;
    }
}

