/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spectrumauctions.sats.core.bidlang.generic.GenericDefinition;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValue;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.opt.domain.Allocation;

public class GenericAllocation<T extends GenericDefinition<S>, S extends Good>
implements Allocation<S> {
    private static final Logger logger = LogManager.getLogger(GenericAllocation.class);
    protected final ImmutableMap<Bidder<S>, GenericValue<T, S>> values;

    public GenericAllocation(Builder<T, S> builder) {
        this.values = ImmutableMap.copyOf((Map)((Builder)builder).storedValues);
    }

    public ImmutableMap<T, Integer> getQuantities(Bidder<S> bidder) {
        return ((GenericValue)this.values.get(bidder)).getQuantities();
    }

    @Override
    public Bundle<S> getAllocation(Bidder<S> bidder) {
        return ((GenericValue)this.values.get(bidder)).anyConsistentBundle();
    }

    public GenericValue<T, S> getGenericAllocation(Bidder<S> bidder) {
        return (GenericValue)this.values.get(bidder);
    }

    @Override
    public Collection<Bidder<S>> getWinners() {
        return this.values.keySet();
    }

    @Override
    public BigDecimal getTotalValue() {
        BigDecimal sum = BigDecimal.ZERO;
        for (GenericValue genVal : this.values.values()) {
            sum = sum.add(genVal.getValue());
        }
        return sum;
    }

    @Override
    public BigDecimal getTradeValue(Bidder<S> bidder) {
        if (bidder == null || !this.values.containsKey(bidder)) {
            return BigDecimal.ZERO;
        }
        return ((GenericValue)this.values.get(bidder)).getValue();
    }

    @Override
    public Allocation<S> getAllocationWithTrueValues() {
        Builder builder = new Builder();
        for (Map.Entry bidderEntry : this.values.entrySet()) {
            BigDecimal trueValue = ((Bidder)bidderEntry.getKey()).calculateValue(((GenericValue)bidderEntry.getValue()).anyConsistentBundle());
            GenericValue.Builder trueEntryBuilder = new GenericValue.Builder(trueValue);
            for (Map.Entry quantities : ((GenericValue)bidderEntry.getValue()).getQuantities().entrySet()) {
                trueEntryBuilder.putQuantity((GenericDefinition)quantities.getKey(), (Integer)quantities.getValue());
            }
            builder.putGenericValue((Bidder)bidderEntry.getKey(), trueEntryBuilder.build());
        }
        GenericAllocation allocationWithTrueValues = new GenericAllocation(builder);
        if (this.equals(allocationWithTrueValues)) {
            logger.warn("Requested allocation with true values when initial allocation already included true values.");
        }
        return allocationWithTrueValues;
    }

    public static class Builder<G extends GenericDefinition<T>, T extends Good> {
        private Map<Bidder<T>, GenericValue<G, T>> storedValues = new HashMap<Bidder<T>, GenericValue<G, T>>();

        public void putGenericValue(Bidder<T> bidder, GenericValue<G, T> value) {
            Preconditions.checkNotNull(bidder);
            Preconditions.checkNotNull(value);
            this.storedValues.put(bidder, value);
        }
    }
}

