/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.domain;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.UnequalWorldsException;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.opt.domain.Allocation;

public final class ItemAllocation<T extends Good>
implements Allocation<T> {
    private static final Logger logger = LogManager.getLogger(ItemAllocation.class);
    private final World world;
    private final Map<Bidder<T>, Bundle<T>> alloc;
    private final Map<Bidder<T>, BigDecimal> declaredValues;
    private final BigDecimal totalValue;

    private ItemAllocation(ItemAllocationBuilder<T> builder) {
        this.world = ((ItemAllocationBuilder)builder).world;
        this.alloc = ((ItemAllocationBuilder)builder).alloc;
        if (((ItemAllocationBuilder)builder).declaredValues == null) {
            this.declaredValues = new HashMap<Bidder<T>, BigDecimal>();
            for (Map.Entry<Bidder<T>, Bundle<T>> entry : this.alloc.entrySet()) {
                this.declaredValues.put(entry.getKey(), entry.getKey().calculateValue(entry.getValue()));
            }
        } else {
            this.declaredValues = ((ItemAllocationBuilder)builder).declaredValues;
        }
        this.totalValue = ((ItemAllocationBuilder)builder).totalValue == null ? BigDecimal.valueOf(this.declaredValues.values().stream().mapToDouble(BigDecimal::doubleValue).sum()) : ((ItemAllocationBuilder)builder).totalValue;
    }

    @Override
    public Collection<Bidder<T>> getWinners() {
        return this.alloc.keySet();
    }

    @Override
    public Bundle<T> getAllocation(Bidder<T> bidder) {
        Bundle<T> candidate = this.alloc.get(bidder);
        if (candidate == null) {
            if (bidder.getWorld().equals(this.world)) {
                return new Bundle();
            }
            throw new UnequalWorldsException("BidderWorldId: " + bidder.getWorldId() + " AllocationWorldId: " + this.world.getId());
        }
        return candidate;
    }

    @Override
    public BigDecimal getTotalValue() {
        return this.totalValue;
    }

    @Override
    public BigDecimal getTradeValue(Bidder<T> bidder) {
        return this.declaredValues.getOrDefault(bidder, BigDecimal.ZERO);
    }

    @Override
    public Allocation<T> getAllocationWithTrueValues() {
        ItemAllocationBuilder<T> builder = new ItemAllocationBuilder<T>();
        return builder.withAllocation(this.alloc).withWorld(this.world).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemAllocation that = (ItemAllocation)o;
        if (this.world != null ? !this.world.equals(that.world) : that.world != null) {
            return false;
        }
        if (this.alloc != null ? !this.alloc.equals(that.alloc) : that.alloc != null) {
            return false;
        }
        if (this.declaredValues != null ? !this.declaredValues.equals(that.declaredValues) : that.declaredValues != null) {
            return false;
        }
        return this.getTotalValue() != null ? this.getTotalValue().equals(that.getTotalValue()) : that.getTotalValue() == null;
    }

    public int hashCode() {
        int result = this.world != null ? this.world.hashCode() : 0;
        result = 31 * result + (this.alloc != null ? this.alloc.hashCode() : 0);
        result = 31 * result + (this.declaredValues != null ? this.declaredValues.hashCode() : 0);
        result = 31 * result + (this.getTotalValue() != null ? this.getTotalValue().hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder allocation = new StringBuilder("[");
        for (Map.Entry<Bidder<T>, Bundle<T>> entry : this.alloc.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            allocation.append(entry.getKey().getSetupType()).append(": ").append(entry.getValue().itemIds(",")).append(";    ");
        }
        allocation.append("]");
        StringBuilder values = new StringBuilder("[");
        for (Map.Entry<Bidder<T>, BigDecimal> entry : this.declaredValues.entrySet()) {
            values.append(entry.getKey().getSetupType()).append(": ").append(entry.getValue()).append(";    ");
        }
        values.append("]");
        return "ItemAllocation{alloc=" + allocation.toString() + ", declaredValues=" + values.toString() + ", totalValue=" + this.totalValue + '}';
    }

    public static final class ItemAllocationBuilder<T extends Good> {
        private World world;
        private Map<Bidder<T>, Bundle<T>> alloc;
        private BigDecimal totalValue;
        private Map<Bidder<T>, BigDecimal> declaredValues;

        public ItemAllocationBuilder<T> withWorld(World world) {
            this.setWorld(world);
            return this;
        }

        public ItemAllocationBuilder<T> withAllocation(Map<Bidder<T>, Bundle<T>> alloc) {
            this.setAlloc(alloc);
            return this;
        }

        public ItemAllocationBuilder<T> withTotalValue(BigDecimal totalValue) {
            this.setTotalValue(totalValue);
            return this;
        }

        public ItemAllocationBuilder<T> withDeclaredValues(Map<Bidder<T>, BigDecimal> declaredValues) {
            this.setDeclaredValues(declaredValues);
            return this;
        }

        public ItemAllocation<T> build() {
            return new ItemAllocation(this);
        }

        private void setWorld(World world) {
            this.world = world;
        }

        private void setAlloc(Map<Bidder<T>, Bundle<T>> alloc) {
            this.alloc = alloc;
        }

        private void setTotalValue(BigDecimal totalValue) {
            this.totalValue = totalValue;
        }

        public void setDeclaredValues(Map<Bidder<T>, BigDecimal> declaredValues) {
            this.declaredValues = declaredValues;
        }
    }
}

