/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.gsvm;

import com.google.common.base.Preconditions;
import edu.harvard.econcs.jopt.solver.IMIP;
import edu.harvard.econcs.jopt.solver.IMIPResult;
import edu.harvard.econcs.jopt.solver.client.SolverClient;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.gsvm.GSVMBidder;
import org.spectrumauctions.sats.core.model.gsvm.GSVMLicense;
import org.spectrumauctions.sats.core.model.gsvm.GSVMWorld;
import org.spectrumauctions.sats.opt.domain.ItemAllocation;
import org.spectrumauctions.sats.opt.domain.WinnerDeterminator;
import org.spectrumauctions.sats.opt.model.ModelMIP;

public class GSVMStandardMIP
extends ModelMIP
implements WinnerDeterminator<GSVMLicense> {
    private Map<GSVMBidder, Map<GSVMLicense, Map<Integer, Variable>>> gMap;
    private Map<GSVMBidder, Map<GSVMLicense, Double>> valueMap;
    private Map<GSVMBidder, Integer> tauHatMap;
    private List<GSVMBidder> population;
    private GSVMWorld world;
    private boolean allowAssigningLicensesWithZeroBasevalue;

    public GSVMStandardMIP(List<GSVMBidder> population) {
        this(population.iterator().next().getWorld(), population, true);
    }

    public GSVMStandardMIP(GSVMWorld world, List<GSVMBidder> population) {
        this(world, population, true);
    }

    public GSVMStandardMIP(GSVMWorld world, List<GSVMBidder> population, boolean allowAssigningLicensesWithZeroBasevalue) {
        this.allowAssigningLicensesWithZeroBasevalue = allowAssigningLicensesWithZeroBasevalue;
        this.population = population;
        this.world = world;
        this.tauHatMap = new HashMap<GSVMBidder, Integer>();
        this.valueMap = new HashMap<GSVMBidder, Map<GSVMLicense, Double>>();
        this.getMip().setObjectiveMax(true);
        this.initValues();
        this.initVariables();
        this.build();
    }

    @Override
    public WinnerDeterminator<GSVMLicense> getWdWithoutBidder(Bidder<GSVMLicense> bidder) {
        Preconditions.checkArgument((boolean)this.population.contains(bidder));
        return new GSVMStandardMIP(this.population.stream().filter(b -> !b.equals(bidder)).collect(Collectors.toList()));
    }

    @Override
    public ItemAllocation<GSVMLicense> calculateAllocation() {
        SolverClient solver = new SolverClient();
        IMIPResult result = solver.solve((IMIP)this.getMip());
        HashMap allocation = new HashMap();
        for (GSVMBidder bidder : this.population) {
            Bundle<GSVMLicense> bundle = new Bundle<GSVMLicense>();
            for (GSVMLicense license : this.world.getLicenses()) {
                if (!this.allowAssigningLicensesWithZeroBasevalue && !(this.valueMap.get(bidder).get(license) > 0.0)) continue;
                for (int tau = 0; tau < this.tauHatMap.get(bidder); ++tau) {
                    if (result.getValue(this.gMap.get(bidder).get(license).get(tau)) != 1.0) continue;
                    bundle.add(license);
                }
            }
            allocation.put(bidder, bundle);
        }
        ItemAllocation.ItemAllocationBuilder builder = new ItemAllocation.ItemAllocationBuilder().withWorld(this.world).withTotalValue(BigDecimal.valueOf(result.getObjectiveValue())).withAllocation(allocation);
        return builder.build();
    }

    public Map<Integer, Variable> getXVariables(GSVMBidder bidder, GSVMLicense license) {
        for (GSVMBidder b : this.population) {
            if (!b.equals(bidder)) continue;
            for (GSVMLicense l : this.world.getLicenses()) {
                if (!l.equals(license)) continue;
                return this.gMap.get(b).get(l);
            }
        }
        return new HashMap<Integer, Variable>();
    }

    @Override
    public WinnerDeterminator<GSVMLicense> copyOf() {
        return new GSVMStandardMIP(this.population);
    }

    @Override
    public void adjustPayoffs(Map<Bidder<GSVMLicense>, Double> payoffs) {
        throw new UnsupportedOperationException("The GSVM MIP does not support CCG yet.");
    }

    private void build() {
        int tau;
        for (GSVMBidder bidder : this.population) {
            for (Object license : this.world.getLicenses()) {
                if (!this.allowAssigningLicensesWithZeroBasevalue && !(this.valueMap.get(bidder).get(license) > 0.0)) continue;
                for (int tau2 = 0; tau2 < this.tauHatMap.get(bidder); ++tau2) {
                    this.getMip().addObjectiveTerm(this.calculateComplementarityMarkup(tau2 + 1) * this.valueMap.get(bidder).get(license), this.gMap.get(bidder).get(license).get(tau2));
                }
            }
        }
        for (GSVMLicense license : this.world.getLicenses()) {
            Constraint constraint = new Constraint(CompareType.LEQ, 1.0, "SupplyConstraint license=" + license.getId());
            for (GSVMBidder bidder : this.population) {
                if (!this.allowAssigningLicensesWithZeroBasevalue && !(this.valueMap.get(bidder).get(license) > 0.0)) continue;
                for (tau = 0; tau < this.tauHatMap.get(bidder); ++tau) {
                    constraint.addTerm(1.0, this.gMap.get(bidder).get(license).get(tau));
                }
            }
            this.getMip().add(constraint);
        }
        for (GSVMLicense j : this.world.getLicenses()) {
            for (GSVMBidder bidder : this.population) {
                Constraint constraint = new Constraint(CompareType.GEQ, 0.0);
                for (GSVMLicense k : this.world.getLicenses()) {
                    if (!this.allowAssigningLicensesWithZeroBasevalue && !(this.valueMap.get(bidder).get(k) > 0.0)) continue;
                    for (int tau3 = 0; tau3 < this.tauHatMap.get(bidder); ++tau3) {
                        constraint.addTerm(1.0, this.gMap.get(bidder).get(k).get(tau3));
                    }
                }
                for (tau = 0; tau < this.tauHatMap.get(bidder); ++tau) {
                    if (!this.allowAssigningLicensesWithZeroBasevalue && !(this.valueMap.get(bidder).get(j) > 0.0)) continue;
                    constraint.addTerm((double)(-(tau + 1)), this.gMap.get(bidder).get(j).get(tau));
                }
                this.getMip().add(constraint);
            }
        }
    }

    private void initValues() {
        for (GSVMBidder bidder : this.population) {
            this.valueMap.put(bidder, new HashMap());
            int tauCounter = 0;
            for (GSVMLicense license : this.world.getLicenses()) {
                BigDecimal val = bidder.getBaseValues().getOrDefault(license.getId(), BigDecimal.ZERO);
                if (this.allowAssigningLicensesWithZeroBasevalue || val.doubleValue() > 0.0) {
                    ++tauCounter;
                }
                this.valueMap.get(bidder).put(license, val.doubleValue());
            }
            this.tauHatMap.put(bidder, tauCounter);
        }
    }

    private OptionalDouble getValue(int i, int j) {
        return this.population.stream().filter(bidder -> bidder.getId() == (long)i).mapToDouble(bidder -> {
            BigDecimal val = bidder.getBaseValues().get(j);
            return val == null ? 0.0 : val.doubleValue();
        }).reduce((element, otherElement) -> {
            throw new IllegalStateException("Error: Multiple values for agent: " + i + " and license: " + j + " in population");
        });
    }

    private void initVariables() {
        this.gMap = new HashMap<GSVMBidder, Map<GSVMLicense, Map<Integer, Variable>>>();
        for (GSVMBidder bidder : this.population) {
            this.gMap.put(bidder, new HashMap());
            for (GSVMLicense license : this.world.getLicenses()) {
                if (!this.allowAssigningLicensesWithZeroBasevalue && !(this.valueMap.get(bidder).get(license) > 0.0)) continue;
                this.gMap.get(bidder).put(license, new HashMap());
                for (int tau = 0; tau < this.tauHatMap.get(bidder); ++tau) {
                    Variable var = new Variable("g_i[" + (int)bidder.getId() + "]j[" + (int)license.getId() + "]t[" + tau + "]", VarType.BOOLEAN, 0.0, 1.0);
                    this.getMip().add(var);
                    this.gMap.get(bidder).get(license).put(tau, var);
                }
            }
        }
    }

    private double calculateComplementarityMarkup(int tau) {
        if (tau < 1) {
            throw new IllegalArgumentException("Error: tau has to be >=1");
        }
        return 1.0 + (double)(tau - 1) * 0.2;
    }
}

