/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.gsvm.demandquery;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.harvard.econcs.jopt.solver.IMIP;
import edu.harvard.econcs.jopt.solver.IMIPResult;
import edu.harvard.econcs.jopt.solver.ISolution;
import edu.harvard.econcs.jopt.solver.SolveParam;
import edu.harvard.econcs.jopt.solver.client.SolverClient;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spectrumauctions.sats.core.bidlang.xor.XORValue;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.gsvm.GSVMBidder;
import org.spectrumauctions.sats.core.model.gsvm.GSVMLicense;
import org.spectrumauctions.sats.core.model.gsvm.GSVMWorld;
import org.spectrumauctions.sats.opt.domain.NonGenericDemandQueryMIP;
import org.spectrumauctions.sats.opt.model.ModelMIP;
import org.spectrumauctions.sats.opt.model.gsvm.GSVMStandardMIP;
import org.spectrumauctions.sats.opt.model.gsvm.demandquery.GSVM_DemandQueryMipResult;

public class GSVM_DemandQueryMIP
extends ModelMIP
implements NonGenericDemandQueryMIP<GSVMLicense> {
    private static final Logger logger = LogManager.getLogger(GSVM_DemandQueryMIP.class);
    private static SolverClient solver = new SolverClient();
    private GSVMBidder bidder;
    private GSVMWorld world;
    private GSVMStandardMIP gsvmMip;
    private Set<Variable> variablesOfInterest;
    private Variable priceVar;

    public GSVM_DemandQueryMIP(GSVMBidder bidder, Map<GSVMLicense, BigDecimal> prices) {
        this(bidder, prices, 0.001);
    }

    public GSVM_DemandQueryMIP(GSVMBidder bidder, Map<GSVMLicense, BigDecimal> prices, double epsilon) {
        Preconditions.checkNotNull((Object)bidder);
        this.bidder = bidder;
        Preconditions.checkNotNull(prices);
        this.world = bidder.getWorld();
        Preconditions.checkArgument((prices.size() == this.world.getLicenses().size() ? 1 : 0) != 0);
        this.gsvmMip = new GSVMStandardMIP(Lists.newArrayList((Object[])new GSVMBidder[]{bidder}));
        this.gsvmMip.getMip().setSolveParam(SolveParam.RELATIVE_OBJ_GAP, (Object)epsilon);
        this.priceVar = new Variable("p", VarType.DOUBLE, 0.0, 5.3687091E8);
        this.gsvmMip.getMip().add(this.priceVar);
        this.gsvmMip.getMip().addObjectiveTerm(-1.0, this.priceVar);
        Constraint price = new Constraint(CompareType.EQ, 0.0);
        price.addTerm(-1.0, this.priceVar);
        this.variablesOfInterest = new HashSet<Variable>();
        for (Map.Entry<GSVMLicense, BigDecimal> entry : prices.entrySet()) {
            GSVMLicense license = entry.getKey();
            Map<Integer, Variable> xVariables = this.gsvmMip.getXVariables(bidder, license);
            for (Variable xVariable : xVariables.values()) {
                this.variablesOfInterest.add(xVariable);
                price.addTerm(entry.getValue().doubleValue(), xVariable);
            }
        }
        this.gsvmMip.getMip().add(price);
    }

    public GSVM_DemandQueryMipResult getResult() {
        List<GSVM_DemandQueryMipResult> results = this.getResultPool(1);
        if (results.size() > 1) {
            logger.warn("Requested one solution, got {}.", (Object)results.size());
        }
        return results.get(0);
    }

    @Override
    public List<GSVM_DemandQueryMipResult> getResultPool(int numberOfResults) {
        if (numberOfResults < 1) {
            return Lists.newArrayList();
        }
        this.gsvmMip.getMip().setSolveParam(SolveParam.SOLUTION_POOL_CAPACITY, (Object)numberOfResults);
        this.gsvmMip.getMip().setSolveParam(SolveParam.SOLUTION_POOL_MODE, (Object)4);
        this.gsvmMip.getMip().setVariablesOfInterest(this.variablesOfInterest);
        IMIPResult mipResult = solver.solve((IMIP)this.gsvmMip.getMip());
        logger.debug("Result:\n{}", (Object)mipResult);
        ArrayList<GSVM_DemandQueryMipResult> results = new ArrayList<GSVM_DemandQueryMipResult>();
        for (ISolution sol : mipResult.getPoolSolutions()) {
            HashSet<GSVMLicense> licenses = new HashSet<GSVMLicense>();
            for (GSVMLicense license : this.world.getLicenses()) {
                Map<Integer, Variable> xVars = this.gsvmMip.getXVariables(this.bidder, license);
                for (Variable var : xVars.values()) {
                    double value = sol.getValue(var);
                    if (!(value >= 0.999999) || !(value <= 1.000001)) continue;
                    licenses.add(license);
                }
            }
            Bundle<GSVMLicense> bundle = new Bundle<GSVMLicense>((Collection<GSVMLicense>)licenses);
            XORValue<GSVMLicense> xorValue = new XORValue<GSVMLicense>(bundle, this.bidder.calculateValue(bundle));
            results.add(new GSVM_DemandQueryMipResult(BigDecimal.valueOf(sol.getObjectiveValue()), xorValue));
        }
        return results;
    }
}

