/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.lsvm;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.Graph;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.Vertex;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.VertexCell;
import org.spectrumauctions.sats.core.model.lsvm.LSVMGrid;
import org.spectrumauctions.sats.core.model.lsvm.LSVMLicense;

public class LSVMGridGraph
extends Graph {
    public LSVMGridGraph(LSVMGrid lsvmGrid) {
        List<Vertex> vertices = lsvmGrid.getLicenses().stream().map(license -> new Vertex((int)license.getId() + 1)).collect(Collectors.toList());
        this.addListOfVertices(vertices);
        vertices.forEach(v -> this.addAdjacencyList(new ArrayList<VertexCell>()));
        for (int v2 = 0; v2 < vertices.size(); ++v2) {
            int curr = v2 + 1;
            if (curr % lsvmGrid.getNumberOfColumns() != 0) {
                this.addEdge(curr, curr + 1);
            }
            if (curr + lsvmGrid.getNumberOfColumns() > vertices.size()) continue;
            this.addEdge(curr, curr + lsvmGrid.getNumberOfColumns());
        }
    }

    public Vertex getVertex(LSVMLicense license) {
        return this.getVertices().stream().filter(v -> v.getID() - 1 == (int)license.getId()).findAny().get();
    }
}

