/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.lsvm.demandquery;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.harvard.econcs.jopt.solver.IMIP;
import edu.harvard.econcs.jopt.solver.IMIPResult;
import edu.harvard.econcs.jopt.solver.ISolution;
import edu.harvard.econcs.jopt.solver.SolveParam;
import edu.harvard.econcs.jopt.solver.client.SolverClient;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spectrumauctions.sats.core.bidlang.xor.XORValue;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.lsvm.LSVMBidder;
import org.spectrumauctions.sats.core.model.lsvm.LSVMLicense;
import org.spectrumauctions.sats.core.model.lsvm.LSVMWorld;
import org.spectrumauctions.sats.opt.domain.NonGenericDemandQueryMIP;
import org.spectrumauctions.sats.opt.model.ModelMIP;
import org.spectrumauctions.sats.opt.model.lsvm.LSVMStandardMIP;
import org.spectrumauctions.sats.opt.model.lsvm.demandquery.LSVM_DemandQueryMipResult;

public class LSVM_DemandQueryMIP
extends ModelMIP
implements NonGenericDemandQueryMIP<LSVMLicense> {
    private static final Logger logger = LogManager.getLogger(LSVM_DemandQueryMIP.class);
    private static SolverClient solver = new SolverClient();
    private LSVMBidder bidder;
    private LSVMWorld world;
    private LSVMStandardMIP lsvmMip;
    private Set<Variable> variablesOfInterest;
    private Variable priceVar;

    public LSVM_DemandQueryMIP(LSVMBidder bidder, Map<LSVMLicense, BigDecimal> prices) {
        this(bidder, prices, 0.001);
    }

    public LSVM_DemandQueryMIP(LSVMBidder bidder, Map<LSVMLicense, BigDecimal> prices, double epsilon) {
        Preconditions.checkNotNull((Object)bidder);
        this.bidder = bidder;
        Preconditions.checkNotNull(prices);
        this.world = bidder.getWorld();
        Preconditions.checkArgument((prices.size() == this.world.getLicenses().size() ? 1 : 0) != 0);
        this.lsvmMip = new LSVMStandardMIP(Lists.newArrayList((Object[])new LSVMBidder[]{bidder}));
        this.lsvmMip.getMip().setSolveParam(SolveParam.RELATIVE_OBJ_GAP, (Object)epsilon);
        this.priceVar = new Variable("p", VarType.DOUBLE, 0.0, 5.3687091E8);
        this.lsvmMip.getMip().add(this.priceVar);
        this.lsvmMip.getMip().addObjectiveTerm(-1.0, this.priceVar);
        Constraint price = new Constraint(CompareType.EQ, 0.0);
        price.addTerm(-1.0, this.priceVar);
        this.variablesOfInterest = new HashSet<Variable>();
        for (Map.Entry<LSVMLicense, BigDecimal> entry : prices.entrySet()) {
            LSVMLicense license = entry.getKey();
            Map<Integer, Variable> xVariables = this.lsvmMip.getXVariables(bidder, license);
            for (Variable xVariable : xVariables.values()) {
                this.variablesOfInterest.add(xVariable);
                price.addTerm(entry.getValue().doubleValue(), xVariable);
            }
        }
        this.lsvmMip.getMip().add(price);
    }

    public LSVM_DemandQueryMipResult getResult() {
        List<LSVM_DemandQueryMipResult> results = this.getResultPool(1);
        if (results.size() > 1) {
            logger.warn("Requested one solution, got {}.", (Object)results.size());
        }
        return results.get(0);
    }

    @Override
    public List<LSVM_DemandQueryMipResult> getResultPool(int numberOfResults) {
        if (numberOfResults < 1) {
            return Lists.newArrayList();
        }
        this.lsvmMip.getMip().setSolveParam(SolveParam.SOLUTION_POOL_CAPACITY, (Object)numberOfResults);
        this.lsvmMip.getMip().setSolveParam(SolveParam.SOLUTION_POOL_MODE, (Object)4);
        this.lsvmMip.getMip().setVariablesOfInterest(this.variablesOfInterest);
        IMIPResult mipResult = solver.solve((IMIP)this.lsvmMip.getMip());
        logger.debug("Result:\n{}", (Object)mipResult);
        ArrayList<LSVM_DemandQueryMipResult> results = new ArrayList<LSVM_DemandQueryMipResult>();
        for (ISolution sol : mipResult.getPoolSolutions()) {
            HashSet<LSVMLicense> licenses = new HashSet<LSVMLicense>();
            for (LSVMLicense license : this.world.getLicenses()) {
                Map<Integer, Variable> xVars = this.lsvmMip.getXVariables(this.bidder, license);
                for (Variable var : xVars.values()) {
                    double value = sol.getValue(var);
                    if (!(value >= 0.999999) || !(value <= 1.000001)) continue;
                    licenses.add(license);
                }
            }
            Bundle<LSVMLicense> bundle = new Bundle<LSVMLicense>((Collection<LSVMLicense>)licenses);
            XORValue<LSVMLicense> xorValue = new XORValue<LSVMLicense>(bundle, this.bidder.calculateValue(bundle));
            results.add(new LSVM_DemandQueryMipResult(BigDecimal.valueOf(sol.getObjectiveValue()), xorValue));
        }
        return results;
    }
}

