/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.mrvm.demandquery;

import java.math.BigDecimal;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValue;
import org.spectrumauctions.sats.core.model.mrvm.MRVMGenericDefinition;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLicense;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.opt.domain.GenericAllocation;
import org.spectrumauctions.sats.opt.domain.GenericDemandQueryResult;

public final class MRVMDemandQueryMipResult
implements GenericDemandQueryResult<MRVMGenericDefinition, MRVMLicense> {
    private final MRVMWorld world;
    private final BigDecimal totalUtility;
    private final GenericValue<MRVMGenericDefinition, MRVMLicense> resultingBundle;

    private MRVMDemandQueryMipResult(Builder builder) {
        this.world = builder.world;
        this.totalUtility = BigDecimal.valueOf(builder.totalUtility);
        this.resultingBundle = builder.result;
    }

    @Override
    public GenericValue<MRVMGenericDefinition, MRVMLicense> getResultingBundle() {
        return this.resultingBundle;
    }

    public MRVMWorld getWorld() {
        return this.world;
    }

    public String toString() {
        return "MRVMDemandQueryMipResult{world=" + this.world + ", totalUtility=" + this.totalUtility + ", resultingBundle=" + this.resultingBundle + '}';
    }

    public static final class Builder
    extends GenericAllocation.Builder<MRVMGenericDefinition, MRVMLicense> {
        private MRVMWorld world;
        private double totalUtility;
        private GenericValue<MRVMGenericDefinition, MRVMLicense> result;

        public Builder(MRVMWorld world, double totalUtility, GenericValue<MRVMGenericDefinition, MRVMLicense> result) {
            this.world = world;
            this.totalUtility = totalUtility;
            this.result = result;
        }

        public MRVMDemandQueryMipResult build() {
            return new MRVMDemandQueryMipResult(this);
        }
    }
}

