/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.mrvm.demandquery;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.harvard.econcs.jopt.solver.IMIP;
import edu.harvard.econcs.jopt.solver.IMIPResult;
import edu.harvard.econcs.jopt.solver.ISolution;
import edu.harvard.econcs.jopt.solver.SolveParam;
import edu.harvard.econcs.jopt.solver.client.SolverClient;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValue;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBand;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMGenericDefinition;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLicense;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.opt.domain.GenericDemandQueryMIP;
import org.spectrumauctions.sats.opt.model.ModelMIP;
import org.spectrumauctions.sats.opt.model.mrvm.MRVM_MIP;
import org.spectrumauctions.sats.opt.model.mrvm.demandquery.MRVMDemandQueryMipResult;

public class MRVM_DemandQueryMIP
extends ModelMIP
implements GenericDemandQueryMIP<MRVMGenericDefinition, MRVMLicense> {
    private static final Logger logger = LogManager.getLogger(MRVM_DemandQueryMIP.class);
    private static SolverClient solver = new SolverClient();
    private MRVMBidder bidder;
    private MRVMWorld world;
    private MRVM_MIP mrvmMip;
    private Variable priceVar;

    public MRVM_DemandQueryMIP(MRVMBidder bidder, Map<MRVMGenericDefinition, BigDecimal> prices) {
        this(bidder, prices, 0.001);
    }

    public MRVM_DemandQueryMIP(MRVMBidder bidder, Map<MRVMGenericDefinition, BigDecimal> prices, double epsilon) {
        Preconditions.checkNotNull((Object)bidder);
        this.bidder = bidder;
        Preconditions.checkNotNull(prices);
        this.world = bidder.getWorld();
        Preconditions.checkArgument((prices.size() == this.world.getAllGenericDefinitions().size() ? 1 : 0) != 0);
        this.mrvmMip = new MRVM_MIP(Sets.newHashSet((Object[])new MRVMBidder[]{bidder}));
        this.mrvmMip.getMip().setSolveParam(SolveParam.RELATIVE_OBJ_GAP, (Object)epsilon);
        double scalingFactor = this.mrvmMip.getBidderPartialMips().get(bidder).getScalingFactor();
        this.priceVar = new Variable("p", VarType.DOUBLE, 0.0, 5.3687091E8);
        this.mrvmMip.addVariable(this.priceVar);
        this.mrvmMip.addObjectiveTerm(-1.0, this.priceVar);
        Constraint price = new Constraint(CompareType.EQ, 0.0);
        price.addTerm(-1.0, this.priceVar);
        for (Map.Entry<MRVMGenericDefinition, BigDecimal> entry : prices.entrySet()) {
            MRVMGenericDefinition bandInRegion = entry.getKey();
            Variable xVariable = this.mrvmMip.getWorldPartialMip().getXVariable(bidder, bandInRegion.getRegion(), bandInRegion.getBand());
            price.addTerm(entry.getValue().doubleValue() / scalingFactor, xVariable);
        }
        this.mrvmMip.addConstraint(price);
    }

    public MRVMDemandQueryMipResult getResult() {
        List<MRVMDemandQueryMipResult> results = this.getResultPool(1);
        if (results.size() > 1) {
            logger.warn("Requested one solution, got {}.", (Object)results.size());
        }
        return results.get(0);
    }

    @Override
    public List<MRVMDemandQueryMipResult> getResultPool(int numberOfResults) {
        if (numberOfResults < 1) {
            return Lists.newArrayList();
        }
        this.mrvmMip.getMip().setSolveParam(SolveParam.SOLUTION_POOL_CAPACITY, (Object)numberOfResults);
        this.mrvmMip.getMip().setSolveParam(SolveParam.SOLUTION_POOL_MODE, (Object)4);
        this.mrvmMip.getMip().setVariablesOfInterest(this.mrvmMip.getXVariables());
        IMIPResult mipResult = solver.solve((IMIP)this.mrvmMip.getMip());
        logger.debug("Result:\n{}", (Object)mipResult);
        ArrayList<MRVMDemandQueryMipResult> results = new ArrayList<MRVMDemandQueryMipResult>();
        for (ISolution sol : mipResult.getPoolSolutions()) {
            double unscaledObjVal;
            double resultingPrice;
            double unscaledPrice;
            double scalingFactor = this.mrvmMip.getBidderPartialMips().get(this.bidder).getScalingFactor();
            Variable bidderValueVar = this.mrvmMip.getWorldPartialMip().getValueVariable(this.bidder);
            double resultingValue = sol.getValue(bidderValueVar);
            double unscaledValue = resultingValue * scalingFactor;
            if (Math.abs(unscaledValue - (unscaledPrice = (resultingPrice = sol.getValue(this.priceVar)) * scalingFactor) - (unscaledObjVal = sol.getObjectiveValue() * scalingFactor)) >= 1.0E-5) {
                logger.warn("Values don't match. Delta of {}. Unscaled value = {}, Unscaled price = {}, Unscaled objective value = {}", (Object)(unscaledValue - unscaledPrice - unscaledObjVal), (Object)unscaledValue, (Object)unscaledPrice, (Object)unscaledObjVal);
            }
            GenericValue.Builder valueBuilder = new GenericValue.Builder(BigDecimal.valueOf(unscaledValue));
            for (MRVMRegionsMap.Region region : this.world.getRegionsMap().getRegions()) {
                for (MRVMBand band : this.world.getBands()) {
                    Variable xVar = this.mrvmMip.getWorldPartialMip().getXVariable(this.bidder, region, band);
                    double doubleQuantity = sol.getValue(xVar);
                    int quantity = (int)Math.round(doubleQuantity);
                    if (quantity <= 0) continue;
                    MRVMGenericDefinition def = new MRVMGenericDefinition(band, region);
                    valueBuilder.putQuantity(def, quantity);
                }
            }
            MRVMDemandQueryMipResult.Builder resultBuilder = new MRVMDemandQueryMipResult.Builder(this.world, unscaledValue - unscaledPrice, valueBuilder.build());
            results.add(resultBuilder.build());
        }
        return results;
    }
}

