/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.srvm;

import edu.harvard.econcs.jopt.solver.IMIPResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.spectrumauctions.sats.core.bidlang.generic.GenericValue;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.srvm.SRVMBand;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidder;
import org.spectrumauctions.sats.core.model.srvm.SRVMLicense;
import org.spectrumauctions.sats.core.model.srvm.SRVMWorld;
import org.spectrumauctions.sats.opt.domain.GenericAllocation;

public final class SRVMMipResult
extends GenericAllocation<SRVMBand, SRVMLicense> {
    private final SRVMWorld world;
    private final IMIPResult joptResult;

    private SRVMMipResult(Builder builder) {
        super(builder);
        this.world = builder.world;
        this.joptResult = builder.joptResult;
    }

    public IMIPResult getJoptResult() {
        return this.joptResult;
    }

    public SRVMWorld getWorld() {
        return this.world;
    }

    public String toString() {
        String tab = "\t";
        StringBuilder builder = new StringBuilder();
        ArrayList sortedEntries = new ArrayList(this.values.entrySet());
        Collections.sort(sortedEntries, Comparator.comparing(e -> ((Bidder)e.getKey()).getId()));
        builder.append("===== bidder listing =======").append(System.lineSeparator());
        for (Map.Entry entry : sortedEntries) {
            SRVMBidder bidder = (SRVMBidder)entry.getKey();
            builder.append(((Bidder)entry.getKey()).getId()).append(tab).append(((Bidder)entry.getKey()).getClass().getSimpleName()).append("(").append(bidder.getSetupType()).append(")").append(tab).append(((GenericValue)entry.getValue()).getValue().toString()).append(" #licenses:").append(((GenericValue)entry.getValue()).getTotalQuantity()).append(System.lineSeparator());
        }
        builder.append("===== allocation table =======").append(System.lineSeparator());
        if (!this.values.isEmpty()) {
            SRVMWorld world = (SRVMWorld)((Bidder)this.values.keySet().iterator().next()).getWorld();
            ArrayList<SRVMBand> orderedBands = new ArrayList<SRVMBand>(world.getBands());
            Collections.sort(orderedBands, (b1, b2) -> Integer.valueOf(b1.getName().length()).compareTo(b2.getName().length()));
            for (SRVMBand band : orderedBands) {
                builder.append(tab).append(band.getName());
            }
            builder.append(System.lineSeparator());
            for (Map.Entry entry : sortedEntries) {
                builder.append(tab);
                for (SRVMBand band : orderedBands) {
                    int quantity = ((GenericValue)entry.getValue()).getQuantity(band);
                    builder.append(quantity).append(tab).append(tab).append(tab);
                }
                SRVMBidder bidder = (SRVMBidder)entry.getKey();
                builder.append(((Bidder)entry.getKey()).getClass().getSimpleName()).append(((Bidder)entry.getKey()).getId()).append(" (").append(bidder.getSetupType()).append(")");
                builder.append(System.lineSeparator());
            }
        }
        return builder.toString();
    }

    public static final class Builder
    extends GenericAllocation.Builder<SRVMBand, SRVMLicense> {
        private SRVMWorld world;
        private final IMIPResult joptResult;

        public Builder(SRVMWorld world, IMIPResult joptResult) {
            this.world = world;
            this.joptResult = joptResult;
        }

        public SRVMMipResult build() {
            return new SRVMMipResult(this);
        }
    }
}

