/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.xor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.math.DoubleMath;
import edu.harvard.econcs.jopt.solver.IMIP;
import edu.harvard.econcs.jopt.solver.IMIPResult;
import edu.harvard.econcs.jopt.solver.client.SolverClient;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.MIP;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.spectrumauctions.sats.core.bidlang.xor.XORBid;
import org.spectrumauctions.sats.core.bidlang.xor.XORValue;
import org.spectrumauctions.sats.core.model.Bidder;
import org.spectrumauctions.sats.core.model.Bundle;
import org.spectrumauctions.sats.core.model.Good;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.opt.domain.Allocation;
import org.spectrumauctions.sats.opt.domain.ItemAllocation;
import org.spectrumauctions.sats.opt.domain.WinnerDeterminator;

public class XORWinnerDetermination<T extends Good>
implements WinnerDeterminator<T> {
    private Map<XORValue<T>, Variable> bidVariables = new HashMap<XORValue<T>, Variable>();
    private Collection<XORBid<T>> bids;
    private IMIP winnerDeterminationProgram;
    private Allocation<T> result = null;
    private World world;
    private double scalingFactor = 1.0;

    public XORWinnerDetermination(Collection<XORBid<T>> bids) {
        Preconditions.checkNotNull(bids);
        Preconditions.checkArgument((!bids.isEmpty() ? 1 : 0) != 0);
        this.bids = bids;
        double maxValue = -1.0;
        for (XORBid<T> bid : bids) {
            for (XORValue<T> value : bid.getValues()) {
                if (!(value.value().doubleValue() > maxValue)) continue;
                maxValue = value.value().doubleValue();
            }
        }
        if (maxValue > 4.83183819E8) {
            this.scalingFactor = 0.9 / maxValue * 5.3687091E8;
        }
        this.world = bids.iterator().next().getBidder().getWorld();
        this.winnerDeterminationProgram = this.createWinnerDeterminationMIP();
    }

    private IMIP createWinnerDeterminationMIP() {
        MIP wdp = new MIP();
        wdp.setObjectiveMax(true);
        for (XORBid<T> xorBid : this.bids) {
            for (XORValue<T> bundleBid : xorBid.getValues()) {
                Variable bidI = new Variable("Bid " + bundleBid.getId(), VarType.BOOLEAN, 0.0, 1.0);
                wdp.add(bidI);
                wdp.addObjectiveTerm(bundleBid.value().doubleValue() * this.scalingFactor, bidI);
                this.bidVariables.put(bundleBid, bidI);
            }
        }
        HashMap<Good, Constraint> goods = new HashMap<Good, Constraint>();
        for (XORBid<T> xorBid : this.bids) {
            Constraint exclusiveBids = new Constraint(CompareType.LEQ, 1.0);
            for (XORValue<T> bundleBid : xorBid.getValues()) {
                exclusiveBids.addTerm(1.0, this.bidVariables.get(bundleBid));
                for (Good good : bundleBid.getLicenses()) {
                    Constraint noDoubleAssignment = (Constraint)goods.get(good);
                    if (noDoubleAssignment == null) {
                        noDoubleAssignment = new Constraint(CompareType.LEQ, 1.0);
                        goods.put(good, noDoubleAssignment);
                    }
                    noDoubleAssignment.addTerm(1.0, this.bidVariables.get(bundleBid));
                }
            }
            wdp.add(exclusiveBids);
        }
        for (Constraint noDoubleAssignments : goods.values()) {
            wdp.add(noDoubleAssignments);
        }
        return wdp;
    }

    protected IMIP getMIP() {
        return this.winnerDeterminationProgram;
    }

    private Variable getBidVariable(XORValue<T> bundleBid) {
        return this.bidVariables.get(bundleBid);
    }

    @Override
    public WinnerDeterminator<T> getWdWithoutBidder(Bidder bidder) {
        return new XORWinnerDetermination<T>(this.bids.stream().filter(b -> !b.getBidder().equals(bidder)).collect(Collectors.toSet()));
    }

    @Override
    public Allocation<T> calculateAllocation() {
        if (this.result == null) {
            this.result = this.solveWinnerDetermination();
        }
        return this.result;
    }

    @Override
    public WinnerDeterminator<T> copyOf() {
        return new XORWinnerDetermination<T>(this.bids);
    }

    @Override
    public void adjustPayoffs(Map<Bidder<T>, Double> payoffs) {
        for (XORBid<T> bidPerBidder : this.bids) {
            Variable x = new Variable("x_" + bidPerBidder.getBidder().getId(), VarType.BOOLEAN, 0.0, 1.0);
            this.winnerDeterminationProgram.add(x);
            this.winnerDeterminationProgram.addObjectiveTerm(-payoffs.getOrDefault(bidPerBidder.getBidder(), 0.0).doubleValue(), x);
            Constraint x1 = new Constraint(CompareType.GEQ, 0.0);
            Constraint x2 = new Constraint(CompareType.LEQ, 0.0);
            x1.addTerm(-1.0, x);
            x2.addTerm(-5.3687091E8, x);
            bidPerBidder.getValues().forEach(b -> x1.addTerm(1.0, this.bidVariables.get(b)));
            bidPerBidder.getValues().forEach(b -> x2.addTerm(1.0, this.bidVariables.get(b)));
            this.winnerDeterminationProgram.add(x1);
            this.winnerDeterminationProgram.add(x2);
        }
    }

    private Allocation<T> solveWinnerDetermination() {
        SolverClient solver = new SolverClient();
        IMIPResult mipResult = solver.solve(this.getMIP());
        return this.adaptMIPResult(mipResult);
    }

    private Allocation<T> adaptMIPResult(IMIPResult mipResult) {
        HashMap trades = new HashMap();
        HashMap declaredValues = new HashMap();
        double totalValue = 0.0;
        for (XORBid<T> xorBid : this.bids) {
            double bidValue = 0.0;
            ImmutableSet.Builder goodsBuilder = ImmutableSet.builder();
            for (XORValue<T> bundleBid : xorBid.getValues()) {
                if (!DoubleMath.fuzzyEquals((double)mipResult.getValue(this.getBidVariable(bundleBid)), (double)1.0, (double)0.001)) continue;
                goodsBuilder.addAll(bundleBid.getLicenses());
                totalValue += bundleBid.value().doubleValue();
                bidValue += bundleBid.value().doubleValue();
            }
            ImmutableSet goods = goodsBuilder.build();
            if (goods.isEmpty()) continue;
            trades.put(xorBid.getBidder(), new Bundle(goods));
            declaredValues.put(xorBid.getBidder(), BigDecimal.valueOf(bidValue));
        }
        ItemAllocation.ItemAllocationBuilder builder = new ItemAllocation.ItemAllocationBuilder();
        return builder.withAllocation(trades).withTotalValue(BigDecimal.valueOf(totalValue)).withDeclaredValues(declaredValues).withWorld(this.world).build();
    }
}

