/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.api;

import java.io.File;
import java.io.IOException;
import org.spectrumauctions.sats.core.api.IllegalConfigException;
import org.spectrumauctions.sats.core.api.ModelCreator;
import org.spectrumauctions.sats.core.api.PathResult;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.bvm.mbvm.MultiBandValueModel;

public class MBVMModelCreator
extends ModelCreator {
    private final int numberOfBidders;

    protected MBVMModelCreator(Builder builder) {
        super(builder);
        this.numberOfBidders = builder.numberOfBidders;
    }

    @Override
    public PathResult generateResult(File outputFolder) throws UnsupportedBiddingLanguageException, IOException, IllegalConfigException {
        MultiBandValueModel model = new MultiBandValueModel();
        model.setNumberOfBidders(this.numberOfBidders);
        return this.appendTopLevelParamsAndSolve(model, outputFolder);
    }

    public static class Builder
    extends ModelCreator.Builder {
        public int numberOfBidders = new MultiBandValueModel().getNumberOfBidders();

        @Override
        public MBVMModelCreator build() {
            return new MBVMModelCreator(this);
        }

        public int getNumberOfBidders() {
            return this.numberOfBidders;
        }

        public void setNumberOfBidders(int numberOfBidders) {
            this.numberOfBidders = numberOfBidders;
        }
    }
}

