/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidfile;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.util.CacheMap;

public abstract class FileWriter {
    public static final int ROUNDING_SCALE = 4;
    protected final File folder;
    private String defaultFilePrefix = "";
    private CacheMap<String, Integer> fileNameCount = new CacheMap(30);

    public abstract File writeMultiBidderXOR(Collection<BiddingLanguage> var1, int var2, String var3) throws IOException;

    public abstract File writeSingleBidderXOR(BiddingLanguage var1, int var2, String var3) throws IOException;

    public abstract File writeMultiBidderXORQ(Collection<BiddingLanguage> var1, int var2, String var3) throws IOException;

    public abstract File writeSingleBidderXORQ(BiddingLanguage var1, int var2, String var3) throws IOException;

    protected abstract String filetype();

    public FileWriter(File path) {
        if (!path.isDirectory()) {
            path.mkdir();
        }
        this.folder = path;
    }

    protected Path nextNonexistingFile(String filePrefix) {
        File candidate;
        Integer cashedCount = (Integer)this.fileNameCount.get(filePrefix);
        if (cashedCount == null) {
            cashedCount = 0;
        }
        boolean searching = true;
        do {
            if ((candidate = this.getFile(filePrefix, cashedCount)).exists() && candidate.isFile()) {
                Integer n = cashedCount;
                Integer n2 = cashedCount = Integer.valueOf(cashedCount + 1);
                continue;
            }
            searching = false;
        } while (searching);
        this.fileNameCount.put(filePrefix, cashedCount + 1);
        return candidate.toPath();
    }

    private File getFile(String filePrefix, int count) {
        String fileName = filePrefix.concat(String.valueOf(count)).concat(".").concat(this.filetype());
        fileName = this.folder.getAbsolutePath().concat("/" + fileName);
        return new File(fileName);
    }

    public String getDefaultFilePrefix() {
        return this.defaultFilePrefix;
    }

    public void setDefaultFilePrefix(String defaultFilePrefix) {
        this.defaultFilePrefix = defaultFilePrefix;
    }

    public File getFolder() {
        return this.folder;
    }
}

