/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public final class GenericSetsPickN<T>
implements Iterator<Map<T, Integer>> {
    private final ImmutableList<T> quantifiableObjects;
    private final int target;
    private final ColumnWalker firstWalker;
    private Map<T, Integer> next;
    private boolean hasNext;

    public GenericSetsPickN(Map<T, Integer> maxQuantities, int target) {
        Preconditions.checkArgument((target > 0 ? 1 : 0) != 0);
        this.target = target;
        ArrayList<T> quantifiableObjectsIncreasingPriority = new ArrayList<T>(maxQuantities.keySet());
        Collections.reverse(quantifiableObjectsIncreasingPriority);
        this.quantifiableObjects = ImmutableList.copyOf(quantifiableObjectsIncreasingPriority);
        Preconditions.checkArgument((maxQuantities.size() > 0 ? 1 : 0) != 0);
        ColumnWalker previouslyCreatedWalker = null;
        for (Map.Entry<T, Integer> maxQuantity : maxQuantities.entrySet()) {
            previouslyCreatedWalker = new ColumnWalker(previouslyCreatedWalker, maxQuantity.getValue());
        }
        this.firstWalker = previouslyCreatedWalker;
        this.hasNext = true;
        this.next();
    }

    private static void appendZeros(int size, List<Integer> list) {
        while (list.size() < size) {
            list.add(0);
        }
    }

    private static int sum(List<Integer> summands) {
        int result = 0;
        for (int summand : summands) {
            result += summand;
        }
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Map<T, Integer> next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        Map<T, Integer> toReturn = this.next;
        this.prepareNext();
        return toReturn;
    }

    private void prepareNext() {
        List<Integer> nextList = this.firstWalker.walkToNextResult(new ArrayList<Integer>());
        if (nextList == null) {
            this.hasNext = false;
            return;
        }
        GenericSetsPickN.appendZeros(this.quantifiableObjects.size(), nextList);
        this.next = new HashMap<T, Integer>();
        for (int i = 0; i < this.quantifiableObjects.size(); ++i) {
            Object object = this.quantifiableObjects.get(i);
            Integer quantity = nextList.get(i);
            this.next.put(object, quantity);
        }
    }

    private class ColumnWalker {
        private final ColumnWalker nextWalker;
        private final int maxValue;
        private int current;

        private ColumnWalker(ColumnWalker nextWalker, int maxValue) {
            this.nextWalker = nextWalker;
            this.maxValue = maxValue;
            this.current = maxValue;
        }

        private List<Integer> walkToNextResult(List<Integer> previousSteps) {
            if (this.nextWalker == null && this.current == 0) {
                return null;
            }
            int sum = previousSteps.stream().mapToInt(Integer::intValue).sum() + this.current;
            if (sum > GenericSetsPickN.this.target) {
                if (this.current == 0) {
                    return null;
                }
                this.oneStepForward();
                List<Integer> downlinkResult = this.walkToNextResult(previousSteps);
                if (downlinkResult != null) {
                    return downlinkResult;
                }
                return this.walkToNextResult(previousSteps);
            }
            if (sum == GenericSetsPickN.this.target) {
                previousSteps.add(this.current);
                this.oneStepForward();
                return previousSteps;
            }
            previousSteps.add(this.current);
            List<Integer> nextWalkerResult = this.nextWalker == null ? null : this.nextWalker.walkToNextResult(previousSteps);
            if (nextWalkerResult == null) {
                previousSteps.remove(previousSteps.size() - 1);
                if (this.current == 0) {
                    return null;
                }
                this.oneStepForward();
                return this.walkToNextResult(previousSteps);
            }
            return nextWalkerResult;
        }

        private void oneStepForward() {
            --this.current;
            if (this.nextWalker != null) {
                this.nextWalker.reset();
            }
        }

        private void reset() {
            this.current = this.maxValue;
            if (this.nextWalker != null) {
                this.nextWalker.reset();
            }
        }
    }
}

