/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model;

import java.io.Serializable;
import java.util.Comparator;
import java.util.UUID;
import org.spectrumauctions.sats.core.model.SATSGood;
import org.spectrumauctions.sats.core.model.World;

public abstract class License
implements SATSGood,
Serializable {
    private final UUID uuid = UUID.randomUUID();
    private final long longId;
    private final String name;
    protected final long worldId;
    private static final long serialVersionUID = 1L;

    protected License(long longId, long worldId) {
        this.longId = longId;
        this.name = License.toAlphabetic(longId);
        this.worldId = worldId;
    }

    @Override
    public abstract World getWorld();

    public long getLongId() {
        return this.longId;
    }

    public long getWorldId() {
        return this.worldId;
    }

    public static String toAlphabetic(long i) {
        if (i < 0L) {
            return "-" + License.toAlphabetic(-i - 1L);
        }
        long quot = i / 26L;
        long rem = i % 26L;
        char letter = (char)(65L + rem);
        if (quot == 0L) {
            return "" + letter;
        }
        return License.toAlphabetic(quot - 1L) + letter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof License)) {
            return false;
        }
        License other = (License)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getLongId() == other.getLongId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof License;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $longId = this.getLongId();
        result = result * 59 + (int)($longId >>> 32 ^ $longId);
        return result;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public static class IdComparator
    implements Comparator<License>,
    Serializable {
        private static final long serialVersionUID = -251782333802510799L;
        private static Comparator<License> comparator = Comparator.comparingLong(License::getLongId);

        @Override
        public int compare(License arg0, License arg1) {
            return comparator.compare(arg0, arg1);
        }
    }
}

