/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.bvm.bvm;

import java.math.BigDecimal;
import java.util.HashMap;
import org.spectrumauctions.sats.core.model.bvm.BMBidderSetup;
import org.spectrumauctions.sats.core.util.random.DoubleInterval;
import org.spectrumauctions.sats.core.util.random.IntegerInterval;

public final class BVMBidderSetup
extends BMBidderSetup {
    public static final String DEFAULT_SETUP_NAME = "DEFAULT_BASE_VALUE_MODEL_BIDDER_SETUP";

    private BVMBidderSetup(BVMBidderSetupBuilder builder) {
        super(builder);
    }

    public static BVMBidderSetup getDefaultSetup(int numberOfBidders) {
        return new BVMBidderSetupBuilder(DEFAULT_SETUP_NAME, numberOfBidders).build();
    }

    public static final class BVMBidderSetupBuilder
    extends BMBidderSetup.BMBidderSetupBuilder {
        public BVMBidderSetupBuilder(String setupName, int numberOfBidders) {
            super(setupName, numberOfBidders);
            this.putBaseValueInterval("A", new DoubleInterval(120.0, 200.0));
            this.putBaseValueInterval("B", new DoubleInterval(60.0, 90.0));
            this.putValueThresholdInterval("A", new IntegerInterval(6));
            this.putValueThresholdInterval("B", new IntegerInterval(6));
            HashMap<Integer, BigDecimal> synFactorsA = new HashMap<Integer, BigDecimal>();
            synFactorsA.put(2, BigDecimal.valueOf(1.2));
            synFactorsA.put(3, BigDecimal.valueOf(1.4));
            synFactorsA.put(4, BigDecimal.valueOf(1.8));
            this.putSynergyFactors("A", synFactorsA);
            this.putSynergyFactors("B", new HashMap<Integer, BigDecimal>());
        }

        @Override
        public void putValueThresholdInterval(String bandName, IntegerInterval interval) {
            super.putValueThresholdInterval(bandName, interval);
        }

        @Override
        public IntegerInterval removeValueThresholdInterval(String bandName) {
            return super.removeValueThresholdInterval(bandName);
        }

        @Override
        public BVMBidderSetup build() {
            return new BVMBidderSetup(this);
        }
    }
}

