/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.cats;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.HashMap;
import org.spectrumauctions.sats.core.model.BidderSetup;
import org.spectrumauctions.sats.core.model.cats.CATSBidder;
import org.spectrumauctions.sats.core.model.cats.CATSLicense;
import org.spectrumauctions.sats.core.model.cats.CATSWorld;
import org.spectrumauctions.sats.core.util.random.GaussianDistributionRNG;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;

public class CATSBidderSetup
extends BidderSetup {
    private final double privateValueMean;
    private final double privateValueStDev;

    private CATSBidderSetup(Builder builder) {
        super(builder);
        this.privateValueMean = builder.privateValueMean;
        this.privateValueStDev = builder.privateValueStDev;
    }

    HashMap<Long, BigDecimal> drawPrivateValues(RNGSupplier rngSupplier, CATSBidder bidder) {
        GaussianDistributionRNG rng = rngSupplier.getGaussianDistributionRNG();
        CATSWorld world = bidder.getWorld();
        HashMap<Long, BigDecimal> values = new HashMap<Long, BigDecimal>();
        for (CATSLicense license : world.getLicenses()) {
            values.put(license.getLongId(), new BigDecimal(rng.nextGaussian(this.privateValueMean, this.privateValueStDev)));
        }
        return values;
    }

    public static class Builder
    extends BidderSetup.Builder {
        private static final int DEFAULT_NUMBER_OF_BIDDERS = 1;
        private static final double DEFAULT_PRIVATE_VALUE_MEAN = 0.0;
        private static final double DEFAULT_PRIVATE_VALUE_STDEV = 30.0;
        private static final String DEFAULT_SETUP_NAME = "CATS Bidder Setup";
        private double privateValueMean = 0.0;
        private double privateValueStDev = 30.0;

        public Builder() {
            super(DEFAULT_SETUP_NAME, 1);
        }

        public void setPrivateValueParameters(double mean, double stdev) {
            Preconditions.checkArgument((stdev >= 0.0 ? 1 : 0) != 0);
            this.privateValueMean = mean;
            this.privateValueStDev = stdev;
        }

        @Override
        public CATSBidderSetup build() {
            return new CATSBidderSetup(this);
        }
    }
}

