/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.cats.graphalgorithms;

import java.util.LinkedList;
import java.util.List;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.KeyInterface;

public class PriorityQueueMin<T extends KeyInterface> {
    private List<T> _elements;
    private final int _heapLength;
    private int _heapSize;

    public PriorityQueueMin(int length) {
        this._heapLength = length;
        this._elements = new LinkedList<T>();
        this._heapSize = 0;
    }

    public String toString() {
        String str = "Queue (sz=" + this._heapSize + "):\n";
        for (KeyInterface element : this._elements) {
            str = str + element.toString() + " ";
        }
        return str;
    }

    public boolean isEmpty() {
        return this._heapSize == 0;
    }

    public void insert(T element, int idx) {
        ++this._heapSize;
        double key = element.getKey(idx);
        element.setKey(Double.MAX_VALUE, idx);
        this._elements.add(element);
        this.decreaseKey(this._heapSize - 1, key, idx);
    }

    public T min() {
        return (T)((KeyInterface)this._elements.get(0));
    }

    public T extractMin(int idx) {
        if (this._heapSize < 1) {
            throw new RuntimeException("PriorityQueueMax queue is empty");
        }
        KeyInterface max = (KeyInterface)this._elements.get(0);
        this._elements.set(0, (KeyInterface)this._elements.get(this._heapSize - 1));
        this._elements.remove(this._heapSize - 1);
        --this._heapSize;
        this.minHeapify(0, idx);
        return (T)max;
    }

    private void decreaseKey(int position, double key, int idx) {
        if (key > ((KeyInterface)this._elements.get(position)).getKey(idx)) {
            throw new RuntimeException("Wrong key");
        }
        ((KeyInterface)this._elements.get(position)).setKey(key, idx);
        while (position > 0 && ((KeyInterface)this._elements.get((int)Math.floor((position - 1) / 2))).getKey(idx) > ((KeyInterface)this._elements.get(position)).getKey(idx)) {
            int parent = (int)Math.floor((position - 1) / 2);
            KeyInterface tmp = (KeyInterface)this._elements.get(parent);
            this._elements.set(parent, (KeyInterface)this._elements.get(position));
            this._elements.set(position, tmp);
            position = parent;
        }
    }

    public void decreaseKey(T element, double key, int idx) {
        int i = 0;
        for (KeyInterface vc : this._elements) {
            if (vc.equals(element)) {
                this.decreaseKey(i, key, idx);
                return;
            }
            ++i;
        }
    }

    private void minHeapify(int i, int idx) {
        int l = 2 * (i + 1) - 1;
        int r = 2 * (i + 1);
        int largest = i;
        largest = l <= this._heapSize - 1 && ((KeyInterface)this._elements.get(l)).getKey(idx) < ((KeyInterface)this._elements.get(i)).getKey(idx) ? l : i;
        if (r <= this._heapSize - 1 && ((KeyInterface)this._elements.get(r)).getKey(idx) < ((KeyInterface)this._elements.get(largest)).getKey(idx)) {
            largest = r;
        }
        if (largest != i) {
            KeyInterface tmp = (KeyInterface)this._elements.get(largest);
            this._elements.set(largest, (KeyInterface)this._elements.get(i));
            this._elements.set(i, tmp);
            this.minHeapify(largest, idx);
        }
    }
}

