/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.cats.graphalgorithms;

import java.util.LinkedList;
import java.util.List;

public class Vertex {
    private int _id;
    private int _adjListIdx;
    private List<Double> _shortestPathEst;
    private List<Integer> _predecessor;
    private int _color;
    private List<Vertex> _childVertices;

    public Vertex(int id) {
        this._id = id;
        this._adjListIdx = this._id - 1;
        this._color = 0;
        this._shortestPathEst = new LinkedList<Double>();
        this._shortestPathEst.add(0.0);
        this._predecessor = new LinkedList<Integer>();
        this._predecessor.add(0);
        this._childVertices = new LinkedList<Vertex>();
    }

    public Vertex cloneIt() {
        Vertex vrt = new Vertex(this._id);
        vrt.setAdjacencyListIndex(this._adjListIdx);
        vrt.setColor(this._color);
        vrt.setPredecessor(0, 0);
        vrt.setShortestPathEst(0.0, 0);
        return vrt;
    }

    public boolean equals(Object other) {
        Vertex otherVertex = (Vertex)other;
        return this._id == otherVertex.getID();
    }

    public int getID() {
        return this._id;
    }

    public int getAdjacencyListIndex() {
        return this._adjListIdx;
    }

    public double getShortestPathEst(int i) {
        return this._shortestPathEst.get(i);
    }

    public double getShortestPathEst() {
        double minEst = Double.MAX_VALUE;
        for (Double val : this._shortestPathEst) {
            if (!(val < minEst)) continue;
            minEst = val;
        }
        return minEst;
    }

    public int getPredecessor(int i) {
        return this._predecessor.get(i);
    }

    public int getColor() {
        return this._color;
    }

    public Vertex getChildVertex(int i) {
        return this._childVertices.get(i);
    }

    public int getNumberOfChilds() {
        return this._childVertices.size();
    }

    public void setAdjacencyListIndex(int idx) {
        this._adjListIdx = idx;
    }

    public void setShortestPathEst(double d, int i) {
        if (i > this._shortestPathEst.size()) {
            throw new RuntimeException("Wrong index");
        }
        if (i == this._shortestPathEst.size()) {
            this._shortestPathEst.add(d);
        } else {
            this._shortestPathEst.set(i, d);
        }
    }

    public void setPredecessor(int p, int i) {
        if (i > this._predecessor.size()) {
            throw new RuntimeException("Wrong index");
        }
        if (i == this._predecessor.size()) {
            this._predecessor.add(p);
        } else {
            this._predecessor.set(i, p);
        }
    }

    public void setColor(int color) {
        this._color = color;
    }

    public void addChildVertex(Vertex child) {
        this._childVertices.add(child);
    }

    public boolean isAggregative() {
        return this._childVertices.size() > 0;
    }
}

