/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.gsvm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.Good;
import org.marketdesignresearch.mechlib.core.allocationlimits.AllocationLimit;
import org.marketdesignresearch.mechlib.core.bidder.Bidder;
import org.marketdesignresearch.mechlib.core.price.Prices;
import org.marketdesignresearch.mechlib.instrumentation.MipInstrumentation;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.bidlang.xor.DecreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.IncreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.SizeBasedUniqueRandomXOR;
import org.spectrumauctions.sats.core.model.License;
import org.spectrumauctions.sats.core.model.SATSBidder;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.gsvm.GSVMBidderSetup;
import org.spectrumauctions.sats.core.model.gsvm.GSVMLicense;
import org.spectrumauctions.sats.core.model.gsvm.GSVMWorld;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.opt.model.gsvm.GSVMStandardMIP;

public final class GSVMBidder
extends SATSBidder {
    private static final long serialVersionUID = -7275733600491984673L;
    private final int bidderPosition;
    private final HashMap<Long, BigDecimal> values;
    private transient GSVMWorld world;
    private final String description;
    private final AllocationLimit allocationLimit;

    GSVMBidder(GSVMBidderSetup setup, GSVMWorld world, int bidderPosition, long currentId, long population, RNGSupplier rngSupplier) {
        super(setup, population, currentId, world.getId());
        this.world = world;
        this.bidderPosition = bidderPosition % world.getSize();
        this.values = setup.drawValues(rngSupplier, this);
        this.description = setup.getSetupName() + " with interest in licenses " + this.world.getLicenses().stream().filter(l -> this.values.containsKey(l.getLongId())).map(License::getName).collect(Collectors.joining(", ")) + ".";
        this.allocationLimit = setup.getAllocationLimit(this);
        this.store();
    }

    @Override
    public BigDecimal calculateValue(Bundle bundle) {
        ArrayList<Double> values = new ArrayList<Double>();
        int synergyCount = 0;
        for (Good good : bundle.getSingleQuantityGoods()) {
            GSVMLicense license = (GSVMLicense)good;
            if (this.values.containsKey(license.getLongId())) {
                values.add(this.values.get(license.getLongId()).doubleValue());
                ++synergyCount;
                continue;
            }
            if (!this.world.isLegacyGSVM()) continue;
            ++synergyCount;
        }
        double value = 0.0;
        value = values.stream().mapToDouble(Double::doubleValue).sum();
        double factor = 0.0;
        if (synergyCount > 0) {
            factor = 0.2 * (double)(synergyCount - 1);
        }
        return BigDecimal.valueOf(value + value * factor);
    }

    public int getBidderPosition() {
        return this.bidderPosition;
    }

    @Override
    public <T extends BiddingLanguage> T getValueFunction(Class<T> clazz, RNGSupplier rngSupplier) throws UnsupportedBiddingLanguageException {
        if (clazz.isAssignableFrom(SizeBasedUniqueRandomXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new SizeBasedUniqueRandomXOR((Collection<? extends License>)this.world.getLicenses(), rngSupplier, this)));
        }
        if (clazz.isAssignableFrom(IncreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new IncreasingSizeOrderedXOR((Collection<? extends License>)this.world.getLicenses(), this)));
        }
        if (clazz.isAssignableFrom(DecreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new DecreasingSizeOrderedXOR((Collection<? extends License>)this.world.getLicenses(), this)));
        }
        throw new UnsupportedBiddingLanguageException();
    }

    @Override
    public GSVMWorld getWorld() {
        return this.world;
    }

    @Override
    public void refreshReference(World world) {
        Preconditions.checkArgument((world.getId() == this.getWorldId() ? 1 : 0) != 0);
        if (!(world instanceof GSVMWorld)) {
            throw new IllegalArgumentException("World is not of correct type");
        }
        this.world = (GSVMWorld)world;
    }

    @Override
    public SATSBidder drawSimilarBidder(RNGSupplier rngSupplier) {
        return new GSVMBidder((GSVMBidderSetup)this.getSetup(), this.getWorld(), this.getBidderPosition(), this.getLongId(), this.getPopulation(), rngSupplier);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GSVMBidder that = (GSVMBidder)o;
        return this.getBidderPosition() == that.getBidderPosition() && Objects.equals(this.values, that.values) && Objects.equals(this.getWorld(), that.getWorld());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getBidderPosition(), this.values, this.getWorld());
    }

    public Map<Long, BigDecimal> getBaseValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public LinkedHashSet<Bundle> getBestBundles(Prices prices, int maxNumberOfBundles, boolean allowNegative) {
        GSVMStandardMIP mip = new GSVMStandardMIP(this.world, Lists.newArrayList((Object[])new GSVMBidder[]{this}));
        mip.setMipInstrumentation(this.getMipInstrumentation());
        mip.setPurpose(MipInstrumentation.MipPurpose.DEMAND_QUERY.name());
        Variable priceVar = new Variable("p", VarType.DOUBLE, 0.0, 5.3687091E8);
        mip.getMIP().add(priceVar);
        mip.getMIP().addObjectiveTerm(-1.0, priceVar);
        Constraint price = new Constraint(CompareType.EQ, 0.0);
        price.addTerm(-1.0, priceVar);
        for (GSVMLicense license : this.world.getLicenses()) {
            Map<Integer, Variable> xVariables = mip.getXVariables(this, license);
            for (Variable xVariable : xVariables.values()) {
                price.addTerm(prices.getPrice(Bundle.of((Good[])new Good[]{license})).getAmount().doubleValue(), xVariable);
            }
        }
        mip.getMIP().add(price);
        mip.setEpsilon(1.0E-10);
        mip.setTimeLimit(600.0);
        Object bundleSpaceOfInterest = this.world.isLegacyGSVM() ? this.world.getLicenses() : this.getBaseValues().keySet().stream().map(longId -> this.world.getLicenses().stream().filter(l -> l.getLongId() == longId.longValue()).findAny().orElseThrow()).collect(Collectors.toList());
        int maxNumberOfBundlesOfInterest = this.getAllocationLimit().calculateAllocationBundleSpace(bundleSpaceOfInterest);
        maxNumberOfBundles = Math.min(maxNumberOfBundles, maxNumberOfBundlesOfInterest);
        List optimalAllocations = mip.getBestAllocations(maxNumberOfBundles, allowNegative);
        LinkedHashSet result = optimalAllocations.stream().map(allocation -> allocation.allocationOf((Bidder)this).getBundle()).filter(bundle -> allowNegative || this.getUtility((Bundle)bundle, prices).signum() > -1).collect(Collectors.toCollection(LinkedHashSet::new));
        if (result.isEmpty()) {
            result.add(Bundle.EMPTY);
        }
        return result;
    }

    public AllocationLimit getAllocationLimit() {
        return this.allocationLimit;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

