/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.lsvm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.Good;
import org.marketdesignresearch.mechlib.core.bidder.Bidder;
import org.marketdesignresearch.mechlib.core.price.Prices;
import org.marketdesignresearch.mechlib.instrumentation.MipInstrumentation;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.bidlang.xor.DecreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.IncreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.SizeBasedUniqueRandomXOR;
import org.spectrumauctions.sats.core.model.License;
import org.spectrumauctions.sats.core.model.SATSBidder;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.lsvm.LSVMBidderSetup;
import org.spectrumauctions.sats.core.model.lsvm.LSVMLicense;
import org.spectrumauctions.sats.core.model.lsvm.LSVMWorld;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.opt.model.lsvm.LSVMStandardMIP;

public final class LSVMBidder
extends SATSBidder {
    private static final long serialVersionUID = -1774118565772856391L;
    private final int LSVM_A;
    private final int LSVM_B;
    private final List<LSVMLicense> proximity;
    private final HashMap<Long, BigDecimal> values;
    private transient LSVMWorld world;
    private final String description;

    LSVMBidder(LSVMBidderSetup setup, LSVMWorld world, long currentId, long population, RNGSupplier rngSupplier) {
        super(setup, population, currentId, world.getId());
        this.world = world;
        LSVMLicense favorite = setup.drawFavorite(rngSupplier, world);
        this.proximity = setup.getProximitySize() == -1 ? world.getGrid().getLicenses() : world.getGrid().getProximity(favorite, setup.getProximitySize());
        this.values = setup.drawValues(rngSupplier, this);
        this.LSVM_A = setup.getLsvmA();
        this.LSVM_B = setup.getLsvmB();
        this.description = setup.getSetupName() + " which has its headquarter in " + favorite.getName() + ", thus interested in licenses " + this.proximity.stream().map(License::getName).collect(Collectors.joining(", ")) + ".";
        this.store();
    }

    public ImmutableSet<LSVMLicense> getProximity() {
        return ImmutableSet.copyOf(this.proximity);
    }

    @Override
    public BigDecimal calculateValue(Bundle bundle) {
        double value = 0.0;
        Set<LSVMLicense> licences = this.world.isLegacyLSVM() ? bundle.getBundleEntries().stream().map(be -> (LSVMLicense)be.getGood()).collect(Collectors.toSet()) : bundle.getBundleEntries().stream().map(be -> (LSVMLicense)be.getGood()).filter(l -> this.getProximity().contains(l)).collect(Collectors.toSet());
        Set<Set<LSVMLicense>> subpackages = this.world.getGrid().getMaximallyConnectedSubpackages(licences);
        for (Set<LSVMLicense> subset : subpackages) {
            double factor = this.calculateFactor(subset.size());
            value += factor * this.sumOfItemValues(subset);
        }
        return BigDecimal.valueOf(value);
    }

    private double sumOfItemValues(Set<LSVMLicense> subset) {
        double value = 0.0;
        for (LSVMLicense license : subset) {
            if (!this.values.containsKey(license.getLongId())) continue;
            value += this.values.get(license.getLongId()).doubleValue();
        }
        return value;
    }

    @Override
    public <T extends BiddingLanguage> T getValueFunction(Class<T> clazz, RNGSupplier rngSupplier) throws UnsupportedBiddingLanguageException {
        if (clazz.isAssignableFrom(SizeBasedUniqueRandomXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new SizeBasedUniqueRandomXOR((Collection<? extends License>)this.world.getLicenses(), rngSupplier, this)));
        }
        if (clazz.isAssignableFrom(IncreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new IncreasingSizeOrderedXOR((Collection<? extends License>)this.world.getLicenses(), this)));
        }
        if (clazz.isAssignableFrom(DecreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new DecreasingSizeOrderedXOR((Collection<? extends License>)this.world.getLicenses(), this)));
        }
        throw new UnsupportedBiddingLanguageException();
    }

    @Override
    public LSVMWorld getWorld() {
        return this.world;
    }

    @Override
    public void refreshReference(World world) {
        Preconditions.checkArgument((world.getId() == this.getWorldId() ? 1 : 0) != 0);
        if (!(world instanceof LSVMWorld)) {
            throw new IllegalArgumentException("World is not of correct type");
        }
        this.world = (LSVMWorld)world;
    }

    @Override
    public LSVMBidder drawSimilarBidder(RNGSupplier rngSupplier) {
        return new LSVMBidder((LSVMBidderSetup)this.getSetup(), this.getWorld(), this.getLongId(), this.getPopulation(), rngSupplier);
    }

    public Map<Long, BigDecimal> getBaseValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public double calculateFactor(int size) {
        return 1.0 + (double)this.LSVM_A / (100.0 * (1.0 + Math.exp(this.LSVM_B - size)));
    }

    public LinkedHashSet<Bundle> getBestBundles(Prices prices, int maxNumberOfBundles, boolean allowNegative) {
        LSVMStandardMIP mip = new LSVMStandardMIP(this.world, Lists.newArrayList((Object[])new LSVMBidder[]{this}));
        mip.setMipInstrumentation(this.getMipInstrumentation());
        mip.setPurpose(MipInstrumentation.MipPurpose.DEMAND_QUERY.name());
        Variable priceVar = new Variable("p", VarType.DOUBLE, 0.0, 5.3687091E8);
        mip.getMIP().add(priceVar);
        mip.getMIP().addObjectiveTerm(-1.0, priceVar);
        Constraint price = new Constraint(CompareType.EQ, 0.0);
        price.addTerm(-1.0, priceVar);
        for (LSVMLicense license : this.world.getLicenses()) {
            Map<Integer, Variable> xVariables = mip.getXVariables(this, license);
            for (Variable xVariable : xVariables.values()) {
                price.addTerm(prices.getPrice(Bundle.of((Good[])new Good[]{license})).getAmount().doubleValue(), xVariable);
            }
        }
        mip.getMIP().add(price);
        mip.setEpsilon(1.0E-10);
        mip.setTimeLimit(600.0);
        maxNumberOfBundles = this.getWorld().isLegacyLSVM() ? Math.min(maxNumberOfBundles, (int)Math.pow(2.0, this.getWorld().getNumberOfGoods())) : Math.min(maxNumberOfBundles, (int)Math.pow(2.0, this.getProximity().size()));
        List optimalAllocations = mip.getBestAllocations(maxNumberOfBundles, allowNegative);
        LinkedHashSet result = optimalAllocations.stream().map(allocation -> allocation.allocationOf((Bidder)this).getBundle()).filter(bundle -> allowNegative || this.getUtility((Bundle)bundle, prices).signum() > -1).collect(Collectors.toCollection(LinkedHashSet::new));
        if (result.isEmpty()) {
            result.add(Bundle.EMPTY);
        }
        return result;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

