/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.lsvm;

import org.spectrumauctions.sats.core.util.PreconditionUtils;
import org.spectrumauctions.sats.core.util.random.IntegerInterval;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;

public class LSVMWorldSetup {
    private final IntegerInterval numberOfRowsInterval;
    private final IntegerInterval numberOfColumnsInterval;
    private final boolean isLegacyLSVM;

    private LSVMWorldSetup(LSVMWorldSetupBuilder builder) {
        this.numberOfRowsInterval = builder.numberOfRowsInterval;
        this.numberOfColumnsInterval = builder.numberOfColumnsInterval;
        this.isLegacyLSVM = builder.isLegacyLSVM();
    }

    Integer drawRowNumber(UniformDistributionRNG rng) {
        return rng.nextInt(this.numberOfRowsInterval);
    }

    Integer drawColumnNumber(UniformDistributionRNG rng) {
        return rng.nextInt(this.numberOfColumnsInterval);
    }

    public boolean isLegacyLSVM() {
        return this.isLegacyLSVM;
    }

    public static class LSVMWorldSetupBuilder {
        private static final int DEFAULT_NUMBER_OF_ROWS = 3;
        private static final int DEFAULT_NUMBER_OF_COLUMNS = 6;
        private IntegerInterval numberOfRowsInterval = new IntegerInterval(3);
        private IntegerInterval numberOfColumnsInterval = new IntegerInterval(6);
        private boolean isLegacyLSVM = false;

        public void createGridSizeRandomly(IntegerInterval numberOfRows, IntegerInterval numberOfColumns) {
            this.setNumberOfRowsInterval(numberOfRows);
            this.setNumberOfColumnsInterval(numberOfColumns);
        }

        public void setNumberOfRowsInterval(IntegerInterval numberOfRows) {
            PreconditionUtils.checkNotNegative(numberOfRows.getMinValue());
            this.numberOfRowsInterval = numberOfRows;
        }

        public void setNumberOfColumnsInterval(IntegerInterval numberOfColumns) {
            PreconditionUtils.checkNotNegative(numberOfColumns.getMinValue());
            this.numberOfColumnsInterval = numberOfColumns;
        }

        public LSVMWorldSetup build() {
            return new LSVMWorldSetup(this);
        }

        public void setLegacyLSVM(boolean isLegacyLSVM) {
            this.isLegacyLSVM = isLegacyLSVM;
        }

        public boolean isLegacyLSVM() {
            return this.isLegacyLSVM;
        }
    }
}

