/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.BundleEntry;
import org.marketdesignresearch.mechlib.core.Good;
import org.marketdesignresearch.mechlib.core.allocationlimits.AllocationLimit;
import org.marketdesignresearch.mechlib.core.bidder.Bidder;
import org.marketdesignresearch.mechlib.core.price.Prices;
import org.marketdesignresearch.mechlib.instrumentation.MipInstrumentation;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeIncreasing;
import org.spectrumauctions.sats.core.bidlang.generic.SimpleRandomOrder.XORQRandomOrderSimple;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetIncreasing;
import org.spectrumauctions.sats.core.bidlang.xor.DecreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.IncreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.SizeBasedUniqueRandomXOR;
import org.spectrumauctions.sats.core.model.IncompatibleWorldException;
import org.spectrumauctions.sats.core.model.SATSBidder;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidderSetup;
import org.spectrumauctions.sats.core.model.mrvm.MRVMGenericDefinition;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLicense;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.core.model.mrvm.RandomOrderXORQFactory;
import org.spectrumauctions.sats.core.model.mrvm.SizeOrderedGenericFactory;
import org.spectrumauctions.sats.core.model.mrvm.SizeOrderedGenericPowersetFactory;
import org.spectrumauctions.sats.core.util.math.ContinuousPiecewiseLinearFunction;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.core.util.random.UniformDistributionRNG;
import org.spectrumauctions.sats.opt.model.mrvm.MRVM_MIP;

public abstract class MRVMBidder
extends SATSBidder {
    private static final long serialVersionUID = 8394009700504454313L;
    private transient MRVMWorld world;
    private final BigDecimal alpha;
    private final HashMap<Integer, BigDecimal> beta;
    private final HashMap<Integer, BigDecimal> zLow;
    private final HashMap<Integer, BigDecimal> zHigh;
    private AllocationLimit allocationLimit = AllocationLimit.NO;

    MRVMBidder(long id, long populationId, MRVMWorld world, MRVMBidderSetup setup, UniformDistributionRNG rng, AllocationLimit limit) {
        super(setup, populationId, id, world.getId());
        this.world = world;
        this.alpha = setup.drawAlpha(rng);
        this.beta = this.drawBeta(world, setup, rng);
        this.zLow = setup.drawZLow(this.beta, world, rng);
        this.zLow.forEach((key, value) -> Preconditions.checkArgument((value.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0));
        this.zHigh = setup.drawZHigh(this.beta, world, rng);
        this.assertRegionalValuesAssigned();
        this.allocationLimit = limit;
    }

    private HashMap<Integer, BigDecimal> drawBeta(MRVMWorld world, MRVMBidderSetup setup, UniformDistributionRNG rng) {
        HashMap<Integer, BigDecimal> tempBeta = new HashMap<Integer, BigDecimal>();
        for (MRVMRegionsMap.Region region : world.getRegionsMap().getRegions()) {
            tempBeta.put(region.getId(), setup.drawBeta(region, rng));
        }
        return tempBeta;
    }

    private void assertRegionalValuesAssigned() {
        for (MRVMRegionsMap.Region region : this.world.getRegionsMap().getRegions()) {
            Preconditions.checkArgument((this.getBeta(region) != null ? 1 : 0) != 0);
            Preconditions.checkArgument((this.getzLow(region) != null ? 1 : 0) != 0);
            Preconditions.checkArgument((this.getzHigh(region) != null ? 1 : 0) != 0);
        }
        if (this.beta.size() != this.world.getRegionsMap().getNumberOfRegions()) {
            throw new IllegalArgumentException("Defined beta for region which is not part of this world");
        }
    }

    public BigDecimal omegaFactor(MRVMRegionsMap.Region r, BigDecimal sv) {
        BigDecimal population = new BigDecimal(String.valueOf(r.getPopulation()));
        return sv.multiply(this.getBeta(r)).multiply(population);
    }

    public BigDecimal svFunction(MRVMRegionsMap.Region region, BigDecimal c) {
        Preconditions.checkArgument((c.compareTo(BigDecimal.ZERO) >= 0 && c.compareTo(this.world.getMaximumRegionalCapacity()) <= 0 ? 1 : 0) != 0, (Object)("c must be between 0 and the c for all licenses (=" + this.world.getMaximumRegionalCapacity().toString() + ") but is actually " + c.toString()));
        return this.svFunction(region).getY(c);
    }

    public ContinuousPiecewiseLinearFunction svFunction(MRVMRegionsMap.Region region) {
        int population = region.getPopulation();
        BigDecimal beta = this.getBeta(region);
        HashMap<BigDecimal, BigDecimal> cornerPoints = new HashMap<BigDecimal, BigDecimal>();
        cornerPoints.put(BigDecimal.ZERO, BigDecimal.ZERO);
        BigDecimal x1 = this.getzLow(region).multiply(BigDecimal.valueOf(population)).multiply(beta);
        BigDecimal y1 = BigDecimal.valueOf(0.27).multiply(this.alpha);
        cornerPoints.put(x1, y1);
        BigDecimal x2 = this.getzHigh(region).multiply(BigDecimal.valueOf(population)).multiply(beta);
        BigDecimal y2 = BigDecimal.valueOf(0.73).multiply(this.alpha);
        cornerPoints.put(x2, y2);
        BigDecimal x3 = this.world.getMaximumRegionalCapacity();
        BigDecimal y3 = this.alpha;
        cornerPoints.put(x3, y3);
        return new ContinuousPiecewiseLinearFunction(cornerPoints);
    }

    public abstract BigDecimal gammaFactor(MRVMRegionsMap.Region var1, Set<MRVMLicense> var2);

    public abstract Map<MRVMRegionsMap.Region, BigDecimal> gammaFactors(Set<MRVMLicense> var1);

    @Override
    public BigDecimal calculateValue(Bundle bundle) {
        if (bundle.getBundleEntries().isEmpty()) {
            return BigDecimal.ZERO;
        }
        Set<MRVMLicense> licenses = bundle.getBundleEntries().stream().filter(be -> be.getGood() instanceof MRVMLicense && be.getAmount() == 1).map(be -> (MRVMLicense)be.getGood()).collect(Collectors.toSet());
        Set genericBundleEntries = bundle.getBundleEntries().stream().filter(be -> be.getGood() instanceof MRVMGenericDefinition).collect(Collectors.toSet());
        Preconditions.checkArgument((licenses.size() + genericBundleEntries.size() == bundle.getBundleEntries().size() ? 1 : 0) != 0, (Object)"Bundle contains other goods than MRVMLicenses or MRVMGenericDefinitions");
        for (BundleEntry entry : genericBundleEntries) {
            MRVMGenericDefinition def = (MRVMGenericDefinition)entry.getGood();
            List<MRVMLicense> containedLicenses = def.containedGoods();
            int required = entry.getAmount();
            int alreadyThere = (int)licenses.stream().filter(containedLicenses::contains).count();
            for (int index = 0; alreadyThere < required && index < def.getQuantity(); ++index) {
                if (licenses.contains(containedLicenses.get(index))) continue;
                licenses.add(containedLicenses.get(index));
                ++alreadyThere;
            }
        }
        BigDecimal totalValue = BigDecimal.ZERO;
        Map<MRVMRegionsMap.Region, Set<MRVMLicense>> regionalBundles = MRVMWorld.getLicensesPerRegion(licenses);
        Map<MRVMRegionsMap.Region, BigDecimal> gammaFactors = this.gammaFactors(licenses);
        for (Map.Entry<MRVMRegionsMap.Region, Set<MRVMLicense>> regionalBundleEntry : regionalBundles.entrySet()) {
            BigDecimal c = MRVMWorld.c(regionalBundleEntry.getKey(), regionalBundleEntry.getValue());
            BigDecimal sv = this.svFunction(regionalBundleEntry.getKey(), c);
            BigDecimal regionalValue = this.omegaFactor(regionalBundleEntry.getKey(), sv);
            BigDecimal gammaFactor = gammaFactors.get(regionalBundleEntry.getKey());
            BigDecimal discountedRegionalValue = regionalValue.multiply(gammaFactor);
            totalValue = totalValue.add(discountedRegionalValue);
        }
        return totalValue;
    }

    @Override
    public MRVMWorld getWorld() {
        return this.world;
    }

    private void setWorld(MRVMWorld world) {
        this.world = world;
    }

    public BigDecimal getzLow(MRVMRegionsMap.Region region) {
        return this.zLow.get(region.getId());
    }

    public BigDecimal getzHigh(MRVMRegionsMap.Region region) {
        return this.zHigh.get(region.getId());
    }

    public BigDecimal getAlpha() {
        return this.alpha;
    }

    public BigDecimal getBeta(MRVMRegionsMap.Region region) {
        return this.beta.get(region.getId());
    }

    public LinkedHashSet<Bundle> getBestBundles(Prices prices, int maxNumberOfBundles, boolean allowNegative) {
        MRVM_MIP mip = new MRVM_MIP(Sets.newHashSet((Object[])new MRVMBidder[]{this}));
        mip.setMipInstrumentation(this.getMipInstrumentation());
        mip.setPurpose(MipInstrumentation.MipPurpose.DEMAND_QUERY.name());
        double scalingFactor = mip.getBidderPartialMips().get(this).getScalingFactor();
        Variable priceVar = new Variable("p", VarType.DOUBLE, 0.0, 5.3687091E8);
        mip.addVariable(priceVar);
        mip.addObjectiveTerm(-1.0, priceVar);
        Constraint price = new Constraint(CompareType.EQ, 0.0);
        price.addTerm(-1.0, priceVar);
        for (MRVMGenericDefinition bandInRegion : this.getWorld().getAllGenericDefinitions()) {
            Variable xVariable = mip.getWorldPartialMip().getXVariable(this, bandInRegion.getRegion(), bandInRegion.getBand());
            price.addTerm(prices.getPrice(Bundle.of((Good[])new Good[]{bandInRegion})).getAmount().doubleValue() / scalingFactor, xVariable);
        }
        mip.addConstraint(price);
        mip.setEpsilon(1.0E-10);
        mip.setTimeLimit(600.0);
        this.bidderTypeSpecificDemandQueryMIPAdjustments(mip);
        List optimalAllocations = mip.getBestAllocations(maxNumberOfBundles, allowNegative);
        LinkedHashSet result = optimalAllocations.stream().map(allocation -> allocation.allocationOf((Bidder)this).getBundle()).collect(Collectors.toCollection(LinkedHashSet::new));
        if (result.isEmpty()) {
            result.add(Bundle.EMPTY);
        }
        return result;
    }

    protected abstract void bidderTypeSpecificDemandQueryMIPAdjustments(MRVM_MIP var1);

    @Override
    public void refreshReference(World world) {
        if (!(world instanceof MRVMWorld)) {
            throw new IncompatibleWorldException("Wrong world class");
        }
        this.setWorld((MRVMWorld)world);
    }

    @Override
    public <T extends BiddingLanguage> T getValueFunction(Class<T> clazz, RNGSupplier rngSupplier) throws UnsupportedBiddingLanguageException {
        if (clazz.isAssignableFrom(SizeBasedUniqueRandomXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new SizeBasedUniqueRandomXOR(this.world.getLicenses(), rngSupplier, this)));
        }
        if (clazz.isAssignableFrom(IncreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new IncreasingSizeOrderedXOR(this.world.getLicenses(), this)));
        }
        if (clazz.isAssignableFrom(DecreasingSizeOrderedXOR.class)) {
            return (T)((BiddingLanguage)clazz.cast(new DecreasingSizeOrderedXOR(this.world.getLicenses(), this)));
        }
        if (clazz.isAssignableFrom(GenericSizeIncreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericFactory.getSizeOrderedGenericLang(true, this)));
        }
        if (clazz.isAssignableFrom(GenericSizeDecreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericFactory.getSizeOrderedGenericLang(false, this)));
        }
        if (clazz.isAssignableFrom(GenericPowersetIncreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericPowersetFactory.getSizeOrderedGenericLang(true, this)));
        }
        if (clazz.isAssignableFrom(GenericPowersetDecreasing.class)) {
            return (T)((BiddingLanguage)clazz.cast(SizeOrderedGenericPowersetFactory.getSizeOrderedGenericLang(false, this)));
        }
        if (clazz.isAssignableFrom(XORQRandomOrderSimple.class)) {
            return (T)((BiddingLanguage)clazz.cast(RandomOrderXORQFactory.getXORQRandomOrderSimpleLang(this, rngSupplier)));
        }
        throw new UnsupportedBiddingLanguageException();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MRVMBidder)) {
            return false;
        }
        MRVMBidder other = (MRVMBidder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BigDecimal this$alpha = this.getAlpha();
        BigDecimal other$alpha = other.getAlpha();
        if (this$alpha == null ? other$alpha != null : !((Object)this$alpha).equals(other$alpha)) {
            return false;
        }
        HashMap<Integer, BigDecimal> this$beta = this.beta;
        HashMap<Integer, BigDecimal> other$beta = other.beta;
        if (this$beta == null ? other$beta != null : !((Object)this$beta).equals(other$beta)) {
            return false;
        }
        HashMap<Integer, BigDecimal> this$zLow = this.zLow;
        HashMap<Integer, BigDecimal> other$zLow = other.zLow;
        if (this$zLow == null ? other$zLow != null : !((Object)this$zLow).equals(other$zLow)) {
            return false;
        }
        HashMap<Integer, BigDecimal> this$zHigh = this.zHigh;
        HashMap<Integer, BigDecimal> other$zHigh = other.zHigh;
        if (this$zHigh == null ? other$zHigh != null : !((Object)this$zHigh).equals(other$zHigh)) {
            return false;
        }
        AllocationLimit this$allocationLimit = this.getAllocationLimit();
        AllocationLimit other$allocationLimit = other.getAllocationLimit();
        return !(this$allocationLimit == null ? other$allocationLimit != null : !this$allocationLimit.equals(other$allocationLimit));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MRVMBidder;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        BigDecimal $alpha = this.getAlpha();
        result = result * 59 + ($alpha == null ? 43 : ((Object)$alpha).hashCode());
        HashMap<Integer, BigDecimal> $beta = this.beta;
        result = result * 59 + ($beta == null ? 43 : ((Object)$beta).hashCode());
        HashMap<Integer, BigDecimal> $zLow = this.zLow;
        result = result * 59 + ($zLow == null ? 43 : ((Object)$zLow).hashCode());
        HashMap<Integer, BigDecimal> $zHigh = this.zHigh;
        result = result * 59 + ($zHigh == null ? 43 : ((Object)$zHigh).hashCode());
        AllocationLimit $allocationLimit = this.getAllocationLimit();
        result = result * 59 + ($allocationLimit == null ? 43 : $allocationLimit.hashCode());
        return result;
    }

    public AllocationLimit getAllocationLimit() {
        return this.allocationLimit;
    }

    public void setAllocationLimit(AllocationLimit allocationLimit) {
        this.allocationLimit = allocationLimit;
    }
}

