/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.model.mrvm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeIncreasing;
import org.spectrumauctions.sats.core.bidlang.generic.FlatSizeIterators.GenericSizeOrdered;
import org.spectrumauctions.sats.core.model.GenericGood;
import org.spectrumauctions.sats.core.model.SATSBidder;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBand;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMGenericDefinition;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;

public class SizeOrderedGenericFactory
implements Serializable {
    private static final long serialVersionUID = 4716571861676046858L;
    static BandComparator comparator = new BandComparator();

    public static GenericSizeOrdered getSizeOrderedGenericLang(boolean increasing, MRVMBidder bidder) throws UnsupportedBiddingLanguageException {
        ArrayList<MRVMGenericDefinition> bands = new ArrayList<MRVMGenericDefinition>();
        for (MRVMBand band : bidder.getWorld().getBands()) {
            for (MRVMRegionsMap.Region region : bidder.getWorld().getRegionsMap().getRegions()) {
                bands.add(new MRVMGenericDefinition(band, region));
            }
        }
        if (increasing) {
            return new Increasing(bands, bidder);
        }
        return new Decreasing(bands, bidder);
    }

    private static class BandComparator
    implements Comparator<GenericGood>,
    Serializable {
        private static final long serialVersionUID = 6544631181558946919L;

        private BandComparator() {
        }

        @Override
        public int compare(GenericGood o1, GenericGood o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static final class Decreasing
    extends GenericSizeDecreasing {
        private final MRVMBidder bidder;

        protected Decreasing(Collection<MRVMGenericDefinition> allPossibleGenericDefintions, MRVMBidder bidder) throws UnsupportedBiddingLanguageException {
            super(allPossibleGenericDefintions);
            this.bidder = bidder;
        }

        @Override
        public SATSBidder getBidder() {
            return this.bidder;
        }

        @Override
        protected Comparator<GenericGood> getDefComparator() {
            return comparator;
        }
    }

    private static final class Increasing
    extends GenericSizeIncreasing {
        private final MRVMBidder bidder;

        protected Increasing(Collection<MRVMGenericDefinition> allPossibleGenericDefintions, MRVMBidder bidder) throws UnsupportedBiddingLanguageException {
            super(allPossibleGenericDefintions);
            this.bidder = bidder;
        }

        @Override
        public SATSBidder getBidder() {
            return this.bidder;
        }

        @Override
        protected Comparator<GenericGood> getDefComparator() {
            return comparator;
        }
    }
}

