/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.util.file.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.jgrapht.Graph;
import org.marketdesignresearch.mechlib.core.allocationlimits.AllocationLimit;
import org.marketdesignresearch.mechlib.core.allocationlimits.BundleSizeAllocationLimit;
import org.marketdesignresearch.mechlib.core.allocationlimits.BundleSizeAndGoodAllocationLimit;
import org.marketdesignresearch.mechlib.core.allocationlimits.GoodAllocationLimit;
import org.spectrumauctions.sats.core.model.World;
import org.spectrumauctions.sats.core.util.file.FileException;
import org.spectrumauctions.sats.core.util.file.gson.AllocationLimitAdapter;
import org.spectrumauctions.sats.core.util.file.gson.GraphAdapter;

public class GsonWrapper {
    private static final String IMPLEMENTATION_FIELD = "implementation";
    private static final boolean PRETTY_JSON = true;
    private Gson gson;
    private AllocationLimitAdapter allocationLimitAdapter = new AllocationLimitAdapter();

    public GsonWrapper() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Graph.class, (Object)new GraphAdapter());
        builder.registerTypeAdapter(AllocationLimit.class, (Object)this.allocationLimitAdapter);
        builder.registerTypeAdapter(AllocationLimit.NoAllocationLimit.class, (Object)this.allocationLimitAdapter);
        builder.registerTypeAdapter(BundleSizeAllocationLimit.class, (Object)this.allocationLimitAdapter);
        builder.registerTypeAdapter(BundleSizeAndGoodAllocationLimit.class, (Object)this.allocationLimitAdapter);
        builder.registerTypeAdapter(GoodAllocationLimit.class, (Object)this.allocationLimitAdapter);
        builder.disableHtmlEscaping();
        builder.setPrettyPrinting();
        this.gson = builder.create();
    }

    public Gson getGson() {
        return this.gson;
    }

    public <T> T fromJson(Class<T> type, String json) {
        Object object = this.gson.fromJson(json, type);
        return (T)object;
    }

    public String toJson(Object object) {
        JsonElement jsonElement = this.gson.toJsonTree(object);
        jsonElement.getAsJsonObject().addProperty(IMPLEMENTATION_FIELD, object.getClass().getName());
        return this.gson.toJson(jsonElement);
    }

    public Class<?> readClass(String json) {
        String typeString = this.readField(IMPLEMENTATION_FIELD, json);
        try {
            return Class.forName(typeString);
        }
        catch (ClassNotFoundException e) {
            throw new FileException("Type Unknown", e);
        }
    }

    public String readField(String key, String json) {
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = parser.parse(json).getAsJsonObject();
        return jsonObject.get(key).getAsString();
    }

    public void setWorld(World world) {
        this.allocationLimitAdapter.setWorld(world);
    }
}

