/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.mechanism.domains;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.Good;
import org.marketdesignresearch.mechlib.core.bidder.valuefunction.BundleValue;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.model.SATSBidder;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.gsvm.GSVMBidder;
import org.spectrumauctions.sats.core.util.random.RNGSupplier;
import org.spectrumauctions.sats.mechanism.domains.ModelDomain;
import org.spectrumauctions.sats.opt.model.ModelMIP;
import org.spectrumauctions.sats.opt.model.gsvm.GSVMStandardMIP;

public class GSVMDomain
extends ModelDomain<GSVMBidder> {
    public GSVMDomain(List<GSVMBidder> bidders) {
        super(bidders);
    }

    @Override
    public ModelMIP getMIP() {
        return new GSVMStandardMIP(((GSVMBidder)this.getBidders().get(0)).getWorld(), this.getBidders());
    }

    @Override
    public String getName() {
        return super.getName() + " (GSVM)";
    }

    public List<? extends Good> getGoods() {
        return ((GSVMBidder)this.getBidders().iterator().next()).getWorld().getLicenses();
    }

    @Override
    public BiddingLanguage createPriceSamplingBiddingLanguage(final RNGSupplier rngSupplier, final SATSBidder bidder, final int numberOfSamples) throws UnsupportedBiddingLanguageException {
        return new BiddingLanguage(){

            @Override
            public SATSBidder getBidder() {
                return bidder;
            }

            @Override
            public Iterator<BundleValue> iterator() {
                return new Iterator<BundleValue>(){
                    private int number = 0;
                    private Random random;
                    {
                        this.random = new Random(rngSupplier.getUniformDistributionRNG().nextLong());
                    }

                    @Override
                    public boolean hasNext() {
                        return this.number < numberOfSamples;
                    }

                    @Override
                    public BundleValue next() {
                        ++this.number;
                        Bundle bundle = bidder.getAllocationLimit().getUniformRandomBundle(this.random, GSVMDomain.this.getGoods());
                        return new BundleValue(bidder.calculateValue(bundle), bundle);
                    }
                };
            }
        };
    }
}

