/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.mechanism.mlca;

import java.math.BigDecimal;
import java.util.Map;
import org.marketdesignresearch.mechlib.mechanism.auctions.mlca.svr.SupportVectorSetup;
import org.marketdesignresearch.mechlib.mechanism.auctions.mlca.svr.kernels.Kernel;
import org.marketdesignresearch.mechlib.mechanism.auctions.mlca.svr.kernels.KernelDotProductExponential;
import org.marketdesignresearch.mechlib.mechanism.auctions.mlca.svr.kernels.KernelDotProductPolynomial;
import org.marketdesignresearch.mechlib.mechanism.auctions.mlca.svr.kernels.KernelGaussian;
import org.marketdesignresearch.mechlib.mechanism.auctions.mlca.svr.kernels.KernelLinear;
import org.marketdesignresearch.mechlib.mechanism.auctions.mlca.svr.kernels.KernelQuadratic;
import org.marketdesignresearch.mechlib.mechanism.auctions.mlca.svr.kernels.KernelType;

public enum SupportVectorSetupFactory {
    INSTANCE;

    private Map<KernelType, Kernel> gsvmDefaultKernels = Map.of(KernelType.Linear, new KernelLinear(0.0, 0.2), KernelType.Quadratic, new KernelQuadratic(0.0, 1.0, 25.0), KernelType.Polynomial, new KernelDotProductPolynomial(new double[]{0.0, 1.0, 25.0}), KernelType.Exponential, new KernelDotProductExponential(10.0, 10.0), KernelType.Gaussian, new KernelGaussian(20.0, 10.0));
    private Map<KernelType, Kernel> lsvmDefaultKernels = Map.of(KernelType.Linear, new KernelLinear(0.0, 0.0), KernelType.Quadratic, new KernelQuadratic(0.0, 80.0, 0.5), KernelType.Polynomial, new KernelDotProductPolynomial(new double[]{0.0, 80.0, 0.5}), KernelType.Exponential, new KernelDotProductExponential(5.0, 10.0), KernelType.Gaussian, new KernelGaussian(10.0, 10.0));
    private Map<KernelType, Kernel> mrvmDefaultKernels = Map.of(KernelType.Linear, new KernelLinear(0.0, 100.0), KernelType.Quadratic, new KernelQuadratic(0.0, 100.0, 0.1), KernelType.Polynomial, new KernelDotProductPolynomial(new double[]{0.0, 100.0, 0.1}), KernelType.Exponential, new KernelDotProductExponential(100.0, 100.0), KernelType.Gaussian, new KernelGaussian(100.0, 100.0));

    public SupportVectorSetup createDefaultGSVMSupportVectorSetup(KernelType kernelType) {
        return new SupportVectorSetup(3000.0, 0.05, BigDecimal.ONE, this.getRemoveSupportVectors(kernelType), this.gsvmDefaultKernels.get(kernelType));
    }

    public SupportVectorSetup createDefaultLSVMSupportVectorSetup(KernelType kernelType) {
        return new SupportVectorSetup(100.0, 1.0E-4, BigDecimal.ONE, this.getRemoveSupportVectors(kernelType), this.lsvmDefaultKernels.get(kernelType));
    }

    public SupportVectorSetup createDefaultMRVMSupportVectorSetup(KernelType kernelType) {
        return new SupportVectorSetup(100.0, 1.0E-4, BigDecimal.ONE.divide(BigDecimal.valueOf(100000L)), this.getRemoveSupportVectors(kernelType), this.mrvmDefaultKernels.get(kernelType));
    }

    private boolean getRemoveSupportVectors(KernelType type) {
        return type.equals((Object)KernelType.Linear) || type.equals((Object)KernelType.Quadratic);
    }
}

