/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.domain;

import edu.harvard.econcs.jopt.solver.IMIP;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.util.HashSet;
import java.util.Set;

public class PartialMIP {
    private final Set<Variable> manuallyAddedVariables = new HashSet<Variable>();
    private final Set<Constraint> manuallyAddedConstraints = new HashSet<Constraint>();

    protected PartialMIP() {
    }

    public void addVariable(Variable var) {
        this.manuallyAddedVariables.add(var);
    }

    public void addConstraint(Constraint constraint) {
        this.manuallyAddedConstraints.add(constraint);
    }

    public void appendToMip(IMIP mip) {
        this.appendVariablesToMip(mip);
        this.appendConstraintsToMip(mip);
    }

    public void appendVariablesToMip(IMIP mip) {
        for (Variable var : this.getVariables()) {
            mip.add(var);
        }
    }

    public Set<Variable> getVariables() {
        HashSet<Variable> vars = new HashSet<Variable>();
        vars.addAll(this.manuallyAddedVariables);
        return vars;
    }

    public void appendConstraintsToMip(IMIP mip) {
        for (Constraint constraint : this.manuallyAddedConstraints) {
            mip.add(constraint);
        }
    }
}

