/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.lsvm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import edu.harvard.econcs.jopt.solver.ISolution;
import edu.harvard.econcs.jopt.solver.SolveParam;
import edu.harvard.econcs.jopt.solver.mip.CompareType;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.VarType;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.marketdesignresearch.mechlib.core.Allocation;
import org.marketdesignresearch.mechlib.core.BidderAllocation;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.bid.bundle.BundleExactValueBids;
import org.marketdesignresearch.mechlib.core.bid.bundle.BundleValueBids;
import org.marketdesignresearch.mechlib.core.bidder.Bidder;
import org.marketdesignresearch.mechlib.metainfo.MetaInfo;
import org.marketdesignresearch.mechlib.winnerdetermination.WinnerDetermination;
import org.spectrumauctions.sats.core.model.cats.graphalgorithms.Vertex;
import org.spectrumauctions.sats.core.model.lsvm.LSVMBidder;
import org.spectrumauctions.sats.core.model.lsvm.LSVMGrid;
import org.spectrumauctions.sats.core.model.lsvm.LSVMLicense;
import org.spectrumauctions.sats.core.model.lsvm.LSVMWorld;
import org.spectrumauctions.sats.opt.model.ModelMIP;
import org.spectrumauctions.sats.opt.model.lsvm.LSVMGridGraph;

public class LSVMStandardMIP
extends ModelMIP {
    private Map<LSVMBidder, Map<LSVMLicense, Double>> valueMap;
    private List<LSVMBidder> population;
    private LSVMWorld world;
    private Map<LSVMBidder, Map<LSVMLicense, Map<Integer, Variable>>> aVariables;
    private Map<LSVMBidder, Map<Edge, Map<Integer, Variable>>> eVariables;
    private Collection<Collection<Variable>> variableSetsOfInterest = new HashSet<Collection<Variable>>();
    private Map<Edge, Set<Integer>> validPathLengths = new HashMap<Edge, Set<Integer>>();

    public LSVMStandardMIP(List<LSVMBidder> population) {
        this(population.iterator().next().getWorld(), population);
    }

    public LSVMStandardMIP(LSVMWorld world, List<LSVMBidder> population) {
        this.world = world;
        this.population = population;
        this.getMIP().setObjectiveMax(true);
        this.getMIP().setSolveParam(SolveParam.TIME_LIMIT, (Object)3600.0);
        this.initBaseValues();
        this.initA();
        this.initEdge();
        this.initE();
        this.buildObjectiveTerm();
        this.buildSupplyEvalConstraints();
        this.buildEdgeSupplyConstraints();
        this.buildNeighbourConstraints();
        this.buildEdgeConstraints();
        this.buildTauConstraints();
        if (!this.world.isLegacyLSVM()) {
            this.buildLicenceRestrictions();
        }
    }

    @Override
    public ModelMIP getMIPWithout(Bidder bidder) {
        LSVMBidder lsvmBidder = (LSVMBidder)bidder;
        Preconditions.checkArgument((boolean)this.population.contains(lsvmBidder));
        return new LSVMStandardMIP(this.population.stream().filter(b -> !b.equals(lsvmBidder)).collect(Collectors.toList()));
    }

    @Override
    protected Allocation adaptMIPResult(ISolution solution) {
        HashMap<LSVMBidder, BidderAllocation> allocationMap = new HashMap<LSVMBidder, BidderAllocation>();
        for (LSVMBidder bidder : this.population) {
            HashSet<LSVMLicense> licenseSet = new HashSet<LSVMLicense>();
            for (LSVMLicense license : this.world.getLicenses()) {
                for (int tau = 0; tau < this.world.getLicenses().size(); ++tau) {
                    if (!(solution.getValue(this.aVariables.get(bidder).get(license).get(tau)) > 0.0)) continue;
                    licenseSet.add(license);
                }
            }
            Bundle bundle = Bundle.of(licenseSet);
            if (Bundle.EMPTY.equals((Object)bundle)) continue;
            allocationMap.put(bidder, new BidderAllocation(bidder.calculateValue(bundle), bundle, new HashSet()));
        }
        MetaInfo metaInfo = new MetaInfo();
        metaInfo.setNumberOfMIPs(1);
        metaInfo.setMipSolveTime(solution.getSolveTime());
        return new Allocation(allocationMap, (BundleValueBids)new BundleExactValueBids(), metaInfo);
    }

    public Map<Integer, Variable> getXVariables(LSVMBidder bidder, LSVMLicense license) {
        for (LSVMBidder b : this.population) {
            if (!b.equals(bidder)) continue;
            for (LSVMLicense l : this.world.getLicenses()) {
                if (!l.equals(license)) continue;
                return this.aVariables.get(b).get(l);
            }
        }
        return new HashMap<Integer, Variable>();
    }

    @Override
    public ModelMIP copyOf() {
        return new LSVMStandardMIP(this.population);
    }

    @Override
    protected Collection<Collection<Variable>> getVariablesOfInterest() {
        return this.variableSetsOfInterest;
    }

    public WinnerDetermination.PoolMode getSolutionPoolMode() {
        return WinnerDetermination.PoolMode.MODE_3;
    }

    private void buildObjectiveTerm() {
        for (LSVMBidder bidder : this.population) {
            for (LSVMLicense license : this.world.getLicenses()) {
                for (int tau = 0; tau < this.world.getLicenses().size(); ++tau) {
                    double value = this.calculateComplementarityMarkup(tau + 1, bidder) * this.valueMap.get(bidder).get(license);
                    this.getMIP().addObjectiveTerm(value, this.aVariables.get(bidder).get(license).get(tau));
                }
            }
        }
    }

    private void buildSupplyEvalConstraints() {
        for (LSVMLicense license : this.world.getLicenses()) {
            Constraint constraint = new Constraint(CompareType.LEQ, 1.0);
            for (LSVMBidder bidder : this.population) {
                for (int tau = 0; tau < this.world.getLicenses().size(); ++tau) {
                    constraint.addTerm(1.0, this.aVariables.get(bidder).get(license).get(tau));
                }
            }
            this.getMIP().add(constraint);
        }
    }

    private void buildEdgeSupplyConstraints() {
        for (Map.Entry<Edge, Set<Integer>> entry : this.validPathLengths.entrySet()) {
            Constraint constraint = new Constraint(CompareType.LEQ, 1.0);
            for (LSVMBidder bidder : this.population) {
                for (int c = 0; c < this.world.getLicenses().size(); ++c) {
                    if (!entry.getValue().contains(c + 1)) continue;
                    constraint.addTerm(1.0, this.eVariables.get(bidder).get(entry.getKey()).get(c));
                }
            }
            this.getMIP().add(constraint);
        }
    }

    private void buildNeighbourConstraints() {
        for (LSVMBidder bidder : this.population) {
            for (Map.Entry<Edge, Set<Integer>> entry : this.validPathLengths.entrySet()) {
                Edge edge = entry.getKey();
                for (int c = 1; c < this.world.getLicenses().size(); ++c) {
                    if (!entry.getValue().contains(c + 1)) continue;
                    Constraint constraint = new Constraint(CompareType.GEQ, 0.0);
                    constraint.addTerm(-1.0, this.eVariables.get(bidder).get(edge).get(c));
                    for (LSVMLicense x : this.n(this.gMin(edge))) {
                        Edge e;
                        LSVMLicense y;
                        if (x.equals(y = this.gMax(edge)) || !this.validPathLengths.get(e = this.fInv(x, y)).contains(c)) continue;
                        constraint.addTerm(1.0, this.eVariables.get(bidder).get(e).get(c - 1));
                    }
                    this.getMIP().add(constraint);
                }
            }
        }
    }

    private void buildEdgeConstraints() {
        for (LSVMBidder bidder : this.population) {
            for (Map.Entry<Edge, Set<Integer>> entry : this.validPathLengths.entrySet()) {
                Edge edge = entry.getKey();
                Constraint constraint = new Constraint(CompareType.GEQ, 0.0);
                for (int c = 0; c < this.world.getLicenses().size(); ++c) {
                    if (!entry.getValue().contains(c + 1)) continue;
                    constraint.addTerm(-2.0, this.eVariables.get(bidder).get(edge).get(c));
                }
                for (LSVMLicense license : this.f(edge)) {
                    for (int tau = 0; tau < this.world.getLicenses().size(); ++tau) {
                        constraint.addTerm(1.0, this.aVariables.get(bidder).get(license).get(tau));
                    }
                }
                this.getMIP().add(constraint);
            }
        }
    }

    private void buildTauConstraints() {
        for (LSVMBidder bidder : this.population) {
            for (LSVMLicense license : this.world.getLicenses()) {
                Constraint constraint = new Constraint(CompareType.LEQ, 1.0);
                for (int tau = 0; tau < this.world.getLicenses().size(); ++tau) {
                    constraint.addTerm((double)(tau + 1), this.aVariables.get(bidder).get(license).get(tau));
                }
                for (LSVMLicense other : this.world.getLicenses()) {
                    if (other.equals(license)) continue;
                    for (int c = 0; c < this.world.getLicenses().size(); ++c) {
                        Edge edge = this.fInv(other, license);
                        if (!this.validPathLengths.get(edge).contains(c + 1)) continue;
                        constraint.addTerm(-1.0, this.eVariables.get(bidder).get(edge).get(c));
                    }
                }
                this.getMIP().add(constraint);
            }
        }
    }

    private void buildLicenceRestrictions() {
        for (LSVMBidder bidder : this.population) {
            for (LSVMLicense license : this.world.getLicenses()) {
                Map<Integer, Variable> xVariables = this.getXVariables(bidder, license);
                for (Variable xVariable : xVariables.values()) {
                    if (bidder.getProximity().contains((Object)license)) continue;
                    xVariable.setUpperBound(0.0);
                }
            }
        }
    }

    private void initBaseValues() {
        this.valueMap = new HashMap<LSVMBidder, Map<LSVMLicense, Double>>();
        for (LSVMBidder bidder : this.population) {
            this.valueMap.put(bidder, new HashMap());
            for (LSVMLicense license : this.world.getLicenses()) {
                this.valueMap.get(bidder).put(license, bidder.getBaseValues().getOrDefault(license.getLongId(), BigDecimal.ZERO).doubleValue());
            }
        }
    }

    private void initA() {
        this.aVariables = new HashMap<LSVMBidder, Map<LSVMLicense, Map<Integer, Variable>>>();
        for (LSVMBidder bidder : this.population) {
            this.aVariables.put(bidder, new HashMap());
            for (LSVMLicense license : this.world.getLicenses()) {
                HashSet<Variable> xVariables = new HashSet<Variable>();
                this.aVariables.get(bidder).put(license, new HashMap());
                for (int tau = 0; tau < this.world.getLicenses().size(); ++tau) {
                    Variable var = new Variable(String.format("A_i[%d]j[%d]tau[%d]", (int)bidder.getLongId(), (int)license.getLongId(), tau), VarType.BOOLEAN, 0.0, 1.0);
                    this.getMIP().add(var);
                    this.aVariables.get(bidder).get(license).put(tau, var);
                    xVariables.add(var);
                }
                this.variableSetsOfInterest.add(xVariables);
            }
        }
    }

    private void initEdge() {
        for (LSVMLicense l1 : this.world.getLicenses()) {
            for (LSVMLicense l2 : this.world.getLicenses()) {
                Edge edge = new Edge(l1, l2);
                if (this.validPathLengths.containsKey(edge)) continue;
                this.buildValidPathLength(edge);
            }
        }
    }

    private void buildValidPathLength(Edge edge) {
        LSVMGridGraph grid = new LSVMGridGraph(this.world.getGrid());
        Set<Set<Vertex>> allPaths = grid.findAllPaths(grid.getVertex(edge.l1), grid.getVertex(edge.l2));
        List sizeOrderedPaths = allPaths.stream().sorted(Comparator.comparingInt(Set::size)).collect(Collectors.toList());
        ArrayList<Set> solution = new ArrayList<Set>();
        for (Set current : sizeOrderedPaths) {
            if (!solution.stream().noneMatch(current::containsAll)) continue;
            solution.add(current);
        }
        Set valid = solution.stream().map(path -> path.size() - 1).collect(Collectors.toSet());
        this.validPathLengths.put(edge, valid);
    }

    private void initE() {
        this.eVariables = new HashMap<LSVMBidder, Map<Edge, Map<Integer, Variable>>>();
        for (LSVMBidder bidder : this.population) {
            this.eVariables.put(bidder, new HashMap());
            for (Map.Entry<Edge, Set<Integer>> entry : this.validPathLengths.entrySet()) {
                this.eVariables.get(bidder).put(entry.getKey(), new HashMap());
                for (int c = 0; c < this.world.getLicenses().size(); ++c) {
                    if (!entry.getValue().contains(c + 1)) continue;
                    Variable var = new Variable(String.format("E_i[%d]e[%s]c[%d]", (int)bidder.getLongId(), entry.getKey(), c), VarType.BOOLEAN, 0.0, 1.0);
                    this.getMIP().add(var);
                    this.eVariables.get(bidder).get(entry.getKey()).put(c, var);
                }
            }
        }
    }

    private double calculateComplementarityMarkup(int tau, LSVMBidder bidder) {
        if (tau < 1) {
            throw new IllegalArgumentException("Error: tau has to be >=1");
        }
        return bidder.calculateFactor(tau);
    }

    private LSVMLicense gMin(Edge e) {
        int neighbourCountL2;
        int neighbourCountL1 = this.n(e.l1).size();
        if (neighbourCountL1 <= (neighbourCountL2 = this.n(e.l2).size())) {
            return e.l1;
        }
        return e.l2;
    }

    private LSVMLicense gMax(Edge e) {
        Set<LSVMLicense> immutableSet = this.f(e);
        LSVMLicense minLicense = this.gMin(e);
        Set mutableSet = immutableSet.stream().filter(l -> !l.equals(minLicense)).collect(Collectors.toSet());
        assert (mutableSet.size() == 1);
        return (LSVMLicense)mutableSet.iterator().next();
    }

    private Set<LSVMLicense> n(LSVMLicense license) {
        LSVMGrid grid = this.world.getGrid();
        return this.world.getLicenses().stream().filter(x -> grid.isNeighbor((LSVMLicense)x, license)).collect(Collectors.toSet());
    }

    private Set<LSVMLicense> f(Edge e) {
        return ImmutableSet.of((Object)e.l1, (Object)e.l2);
    }

    private Edge fInv(LSVMLicense l1, LSVMLicense l2) {
        for (Edge edge : this.validPathLengths.keySet()) {
            if ((edge.l1 != l1 || edge.l2 != l2) && (edge.l1 != l2 || edge.l2 != l1)) continue;
            return edge;
        }
        throw new IllegalStateException("Error: fInv edge not found");
    }

    public class Edge {
        LSVMLicense l1;
        LSVMLicense l2;

        public Edge(LSVMLicense l1, LSVMLicense l2) {
            if (l1.getLongId() > l2.getLongId()) {
                this.l1 = l1;
                this.l2 = l2;
            } else {
                this.l2 = l1;
                this.l1 = l2;
            }
        }

        public String toString() {
            return "Edge(" + (int)this.l1.getLongId() + "," + (int)this.l2.getLongId() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Edge)) {
                return false;
            }
            Edge other = (Edge)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LSVMLicense this$l1 = this.l1;
            LSVMLicense other$l1 = other.l1;
            if (this$l1 == null ? other$l1 != null : !((Object)this$l1).equals(other$l1)) {
                return false;
            }
            LSVMLicense this$l2 = this.l2;
            LSVMLicense other$l2 = other.l2;
            return !(this$l2 == null ? other$l2 != null : !((Object)this$l2).equals(other$l2));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Edge;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LSVMLicense $l1 = this.l1;
            result = result * 59 + ($l1 == null ? 43 : ((Object)$l1).hashCode());
            LSVMLicense $l2 = this.l2;
            result = result * 59 + ($l2 == null ? 43 : ((Object)$l2).hashCode());
            return result;
        }
    }
}

