/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.mrvm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.math.DoubleMath;
import edu.harvard.econcs.jopt.solver.ISolution;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.marketdesignresearch.mechlib.core.Allocation;
import org.marketdesignresearch.mechlib.core.BidderAllocation;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.BundleEntry;
import org.marketdesignresearch.mechlib.core.Good;
import org.marketdesignresearch.mechlib.core.allocationlimits.AllocationLimitConstraint;
import org.marketdesignresearch.mechlib.core.bid.bundle.BundleExactValueBids;
import org.marketdesignresearch.mechlib.core.bid.bundle.BundleValueBids;
import org.marketdesignresearch.mechlib.core.bidder.Bidder;
import org.marketdesignresearch.mechlib.metainfo.MetaInfo;
import org.spectrumauctions.sats.core.model.GenericGood;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBand;
import org.spectrumauctions.sats.core.model.mrvm.MRVMBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMGenericDefinition;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLicense;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLocalBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMNationalBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionalBidder;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionsMap;
import org.spectrumauctions.sats.core.model.mrvm.MRVMWorld;
import org.spectrumauctions.sats.opt.model.ModelMIP;
import org.spectrumauctions.sats.opt.model.mrvm.MRVMBidderPartialMIP;
import org.spectrumauctions.sats.opt.model.mrvm.MRVMLocalBidderPartialMip;
import org.spectrumauctions.sats.opt.model.mrvm.MRVMNationalBidderPartialMip;
import org.spectrumauctions.sats.opt.model.mrvm.MRVMRegionalBidderPartialMip;
import org.spectrumauctions.sats.opt.model.mrvm.MRVMWorldPartialMip;
import org.spectrumauctions.sats.opt.model.mrvm.Scalor;

public class MRVM_MIP
extends ModelMIP {
    private static final Logger logger = LogManager.getLogger(MRVM_MIP.class);
    public static boolean PRINT_SOLVER_RESULT = false;
    private MRVMWorldPartialMip worldPartialMip;
    private Map<MRVMBidder, MRVMBidderPartialMIP> bidderPartialMips;
    private MRVMWorld world;
    private Collection<MRVMBidder> bidders;
    private double scalingFactor;

    public MRVM_MIP(Collection<MRVMBidder> bidders) {
        Preconditions.checkNotNull(bidders);
        Preconditions.checkArgument((bidders.size() > 0 ? 1 : 0) != 0);
        this.world = bidders.iterator().next().getWorld();
        this.scalingFactor = Scalor.scalingFactor(bidders);
        double biggestPossibleValue = Scalor.biggestUnscaledPossibleValue(bidders).doubleValue() / this.scalingFactor;
        this.bidders = bidders;
        this.worldPartialMip = new MRVMWorldPartialMip(bidders, biggestPossibleValue);
        this.worldPartialMip.appendToMip(this.getMIP());
        this.bidderPartialMips = new HashMap<MRVMBidder, MRVMBidderPartialMIP>();
        for (MRVMBidder bidder : bidders) {
            MRVMBidderPartialMIP bidderPartialMIP;
            MRVMBidder globalBidder;
            if (bidder instanceof MRVMNationalBidder) {
                globalBidder = (MRVMNationalBidder)bidder;
                bidderPartialMIP = new MRVMNationalBidderPartialMip((MRVMNationalBidder)globalBidder, this.scalingFactor, this.worldPartialMip);
            } else if (bidder instanceof MRVMLocalBidder) {
                globalBidder = (MRVMLocalBidder)bidder;
                bidderPartialMIP = new MRVMLocalBidderPartialMip((MRVMLocalBidder)globalBidder, this.scalingFactor, this.worldPartialMip);
            } else {
                globalBidder = (MRVMRegionalBidder)bidder;
                bidderPartialMIP = new MRVMRegionalBidderPartialMip((MRVMRegionalBidder)globalBidder, this.scalingFactor, this.worldPartialMip);
            }
            bidderPartialMIP.appendToMip(this.getMIP());
            this.bidderPartialMips.put(bidder, bidderPartialMIP);
            this.addAllocationLimit(bidder);
        }
    }

    private void addAllocationLimit(MRVMBidder bidder) {
        bidder.getAllocationLimit().getAdditionalVariables().forEach(this::addVariable);
        for (AllocationLimitConstraint constraint : bidder.getAllocationLimit().getConstraints()) {
            Constraint allocationConstraint = new Constraint(constraint.getType(), constraint.getConstant());
            HashMap<GenericGood, Double> alreadeAddedDefinitions = new HashMap<GenericGood, Double>();
            for (AllocationLimitConstraint.AllocationLimitLinearTerm term : constraint.getLinearTerms()) {
                if (term instanceof AllocationLimitConstraint.LinearGoodTerm) {
                    AllocationLimitConstraint.LinearGoodTerm lgt = (AllocationLimitConstraint.LinearGoodTerm)term;
                    if (lgt.getGood() instanceof MRVMGenericDefinition) {
                        MRVMGenericDefinition mgd = (MRVMGenericDefinition)lgt.getGood();
                        allocationConstraint.addTerm(term.getCoefficient(), this.getWorldPartialMip().getXVariable(bidder, mgd.getRegion(), mgd.getBand()));
                        continue;
                    }
                    MRVMLicense license = (MRVMLicense)lgt.getGood();
                    GenericGood mgd = this.world.getGenericDefinitionOf(license);
                    if (alreadeAddedDefinitions.containsKey(mgd)) {
                        if (((Double)alreadeAddedDefinitions.get(mgd)).doubleValue() == term.getCoefficient()) continue;
                        throw new IllegalStateException("Constraint with the same generic good but different coefficients detected. Therefore the Constraint cannot be transformed from MRVMLicence to MRVMGenericGood which would be necessary here.");
                    }
                    alreadeAddedDefinitions.put(mgd, term.getCoefficient());
                    allocationConstraint.addTerm(term.getCoefficient(), this.getWorldPartialMip().getXVariable(bidder, license.getRegion(), license.getBand()));
                    continue;
                }
                if (term instanceof AllocationLimitConstraint.LinearVarTerm) {
                    allocationConstraint.addTerm(((AllocationLimitConstraint.LinearVarTerm)term).getLinearTerm());
                    continue;
                }
                throw new IllegalStateException("Unkown Allocation Limit Linear Term type");
            }
            this.addConstraint(allocationConstraint);
        }
    }

    public void addConstraint(Constraint constraint) {
        this.getMIP().add(constraint);
    }

    public void addVariable(Variable variable) {
        this.getMIP().add(variable);
    }

    public void addObjectiveTerm(double coefficient, Variable variable) {
        this.getMIP().addObjectiveTerm(coefficient, variable);
    }

    @Override
    public MRVM_MIP getMIPWithout(Bidder bidder) {
        MRVMBidder mrvmBidder = (MRVMBidder)bidder;
        Preconditions.checkArgument((boolean)this.bidders.contains(mrvmBidder));
        return new MRVM_MIP(this.bidders.stream().filter(b -> !b.equals(mrvmBidder)).collect(Collectors.toSet()));
    }

    @Override
    public Allocation adaptMIPResult(ISolution solution) {
        if (PRINT_SOLVER_RESULT) {
            logger.info("Result:\n" + solution);
        }
        HashMap<Bidder, BidderAllocation> bidderAllocationMap = new HashMap<Bidder, BidderAllocation>();
        for (Map.Entry<MRVMBidder, MRVMBidderPartialMIP> bidder : this.bidderPartialMips.entrySet()) {
            Variable bidderValueVar = this.worldPartialMip.getValueVariable(bidder.getKey());
            double mipUtilityResult = solution.getValue(bidderValueVar);
            double svScalingFactor = bidder.getValue().getScalingFactor();
            double unscaledValue = mipUtilityResult * svScalingFactor;
            HashSet<BundleEntry> bundleEntries = new HashSet<BundleEntry>();
            for (MRVMRegionsMap.Region region : this.world.getRegionsMap().getRegions()) {
                for (MRVMBand band : this.world.getBands()) {
                    Variable xVar = this.worldPartialMip.getXVariable(bidder.getKey(), region, band);
                    double doubleQuantity = solution.getValue(xVar);
                    int quantity = (int)Math.round(doubleQuantity);
                    if (quantity <= 0) continue;
                    MRVMGenericDefinition def = this.world.getAllGenericDefinitions().stream().filter(g -> g.getBand().equals(band) && g.getRegion().equals(region)).findFirst().get();
                    bundleEntries.add(new BundleEntry((Good)def, quantity));
                }
            }
            Bundle bundle = new Bundle(bundleEntries);
            BigDecimal value = bidder.getKey().getValue(bundle, true);
            if (!DoubleMath.fuzzyEquals((double)unscaledValue, (double)value.doubleValue(), (double)1.0)) {
                logger.warn("MIP value of bidder {}: {}; Actual value: {}. With very high numbers, a deviation can happen. Make sure this is just a relatively small deviation, else check your MIP.", (Object)bidder.getKey().getName(), (Object)BigDecimal.valueOf(unscaledValue).setScale(4, RoundingMode.HALF_UP), (Object)value.setScale(4, RoundingMode.HALF_UP));
            }
            if (Bundle.EMPTY.equals((Object)bundle)) continue;
            bidderAllocationMap.put(bidder.getKey(), new BidderAllocation(value, bundle, new HashSet()));
        }
        MetaInfo metaInfo = new MetaInfo();
        metaInfo.setNumberOfMIPs(1);
        metaInfo.setMipSolveTime(solution.getSolveTime());
        return new Allocation(bidderAllocationMap, (BundleValueBids)new BundleExactValueBids(), metaInfo);
    }

    @Override
    public ModelMIP copyOf() {
        return new MRVM_MIP(this.bidders);
    }

    @Override
    protected Collection<Collection<Variable>> getVariablesOfInterest() {
        HashSet<Collection<Variable>> variablesOfInterest = new HashSet<Collection<Variable>>();
        for (Variable variable : this.getXVariables()) {
            variablesOfInterest.add(Sets.newHashSet((Object[])new Variable[]{variable}));
        }
        return variablesOfInterest;
    }

    public MRVMWorldPartialMip getWorldPartialMip() {
        return this.worldPartialMip;
    }

    public Map<MRVMBidder, MRVMBidderPartialMIP> getBidderPartialMips() {
        return this.bidderPartialMips;
    }

    public Collection<Variable> getXVariables() {
        return this.bidders.stream().map(b -> this.worldPartialMip.getXVariables((MRVMBidder)b)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

