/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.opt.model.srvm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.math.DoubleMath;
import edu.harvard.econcs.jopt.solver.ISolution;
import edu.harvard.econcs.jopt.solver.SolveParam;
import edu.harvard.econcs.jopt.solver.client.SolverClient;
import edu.harvard.econcs.jopt.solver.mip.Constraint;
import edu.harvard.econcs.jopt.solver.mip.Variable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.marketdesignresearch.mechlib.core.Allocation;
import org.marketdesignresearch.mechlib.core.BidderAllocation;
import org.marketdesignresearch.mechlib.core.Bundle;
import org.marketdesignresearch.mechlib.core.BundleEntry;
import org.marketdesignresearch.mechlib.core.Good;
import org.marketdesignresearch.mechlib.core.bid.bundle.BundleExactValueBids;
import org.marketdesignresearch.mechlib.core.bid.bundle.BundleValueBids;
import org.marketdesignresearch.mechlib.core.bidder.Bidder;
import org.marketdesignresearch.mechlib.metainfo.MetaInfo;
import org.spectrumauctions.sats.core.model.srvm.SRVMBand;
import org.spectrumauctions.sats.core.model.srvm.SRVMBidder;
import org.spectrumauctions.sats.core.model.srvm.SRVMWorld;
import org.spectrumauctions.sats.opt.model.ModelMIP;
import org.spectrumauctions.sats.opt.model.srvm.SRVMBidderPartialMIP;
import org.spectrumauctions.sats.opt.model.srvm.SRVMWorldPartialMip;

public class SRVM_MIP
extends ModelMIP {
    private static final Logger logger = LogManager.getLogger(SRVM_MIP.class);
    public static boolean PRINT_SOLVER_RESULT = false;
    private static SolverClient SOLVER = new SolverClient();
    private double scalingFactor;
    public static BigDecimal highestValidVal = BigDecimal.valueOf(535870910L);
    private SRVMWorldPartialMip worldPartialMip;
    private Map<SRVMBidder, SRVMBidderPartialMIP> bidderPartialMips;
    private SRVMWorld world;

    public SRVM_MIP(Collection<SRVMBidder> bidders) {
        Preconditions.checkNotNull(bidders);
        Preconditions.checkArgument((bidders.size() > 0 ? 1 : 0) != 0);
        this.world = bidders.iterator().next().getWorld();
        this.getMIP().setSolveParam(SolveParam.RELATIVE_OBJ_GAP, (Object)0.001);
        this.scalingFactor = SRVM_MIP.calculateScalingFactor(bidders);
        double biggestPossibleValue = SRVM_MIP.biggestUnscaledPossibleValue(bidders).doubleValue() / this.scalingFactor;
        this.worldPartialMip = new SRVMWorldPartialMip(bidders, biggestPossibleValue, this.scalingFactor);
        this.worldPartialMip.appendToMip(this.getMIP());
        this.bidderPartialMips = new HashMap<SRVMBidder, SRVMBidderPartialMIP>();
        for (SRVMBidder bidder : bidders) {
            SRVMBidderPartialMIP bidderPartialMIP = new SRVMBidderPartialMIP(bidder, this.worldPartialMip);
            bidderPartialMIP.appendToMip(this.getMIP());
            this.bidderPartialMips.put(bidder, bidderPartialMIP);
        }
    }

    public static double calculateScalingFactor(Collection<SRVMBidder> bidders) {
        BigDecimal maxVal = SRVM_MIP.biggestUnscaledPossibleValue(bidders);
        if (maxVal.compareTo(highestValidVal) < 0) {
            return 1.0;
        }
        logger.info("Scaling MIP-CALC");
        return maxVal.divide(highestValidVal, RoundingMode.HALF_DOWN).doubleValue();
    }

    public static BigDecimal biggestUnscaledPossibleValue(Collection<SRVMBidder> bidders) {
        BigDecimal biggestValue = BigDecimal.ZERO;
        for (SRVMBidder bidder : bidders) {
            BigDecimal val = bidder.calculateValue(Bundle.of(bidder.getWorld().getLicenses()));
            if (val.compareTo(biggestValue) <= 0) continue;
            biggestValue = val;
        }
        return biggestValue;
    }

    public void addConstraint(Constraint constraint) {
        this.getMIP().add(constraint);
    }

    public void addVariable(Variable variable) {
        this.getMIP().add(variable);
    }

    @Override
    public ModelMIP getMIPWithout(Bidder bidder) {
        SRVMBidder srvmBidder = (SRVMBidder)bidder;
        Preconditions.checkArgument((boolean)this.bidderPartialMips.containsKey(srvmBidder));
        return new SRVM_MIP(this.bidderPartialMips.keySet().stream().filter(b -> !b.equals(srvmBidder)).collect(Collectors.toSet()));
    }

    @Override
    public Allocation adaptMIPResult(ISolution solution) {
        if (PRINT_SOLVER_RESULT) {
            logger.info("Result:\n" + solution);
        }
        HashMap<SRVMBidder, BidderAllocation> bidderAllocationMap = new HashMap<SRVMBidder, BidderAllocation>();
        for (SRVMBidder bidder : this.bidderPartialMips.keySet()) {
            SRVMBand band2;
            double unscaledValue = 0.0;
            for (SRVMBand band2 : this.world.getBands()) {
                Variable bidderVmVar = this.worldPartialMip.getVmVariable(bidder, band2);
                double mipVmUtilityResult = solution.getValue(bidderVmVar);
                Variable bidderVoVar = this.worldPartialMip.getVoVariable(bidder, band2);
                double mipVoUtilityResult = solution.getValue(bidderVoVar);
                double value = (double)bidder.getInterbandSynergyValue().floatValue() * mipVmUtilityResult + mipVoUtilityResult;
                unscaledValue += value * this.worldPartialMip.getScalingFactor();
            }
            HashSet<BundleEntry> bundleEntries = new HashSet<BundleEntry>();
            band2 = this.world.getBands().iterator();
            while (band2.hasNext()) {
                SRVMBand band3 = (SRVMBand)band2.next();
                Variable xVar = this.worldPartialMip.getXVariable(bidder, band3);
                double doubleQuantity = solution.getValue(xVar);
                int quantity = (int)Math.round(doubleQuantity);
                if (quantity <= 0) continue;
                bundleEntries.add(new BundleEntry((Good)band3, quantity));
            }
            Bundle bundle = new Bundle(bundleEntries);
            BigDecimal value = bidder.getValue(bundle);
            if (!DoubleMath.fuzzyEquals((double)unscaledValue, (double)value.doubleValue(), (double)1.0)) {
                logger.warn("MIP value of bidder {}: {}; Actual value: {}. With very high numbers, a deviation can happen. Make sure this is just a relatively small deviation, else check your MIP.", (Object)bidder.getName(), (Object)BigDecimal.valueOf(unscaledValue).setScale(4, RoundingMode.HALF_UP), (Object)value.setScale(4, RoundingMode.HALF_UP));
            }
            if (bundle.equals((Object)Bundle.EMPTY)) continue;
            bidderAllocationMap.put(bidder, new BidderAllocation(value, bundle, new HashSet()));
        }
        MetaInfo metaInfo = new MetaInfo();
        metaInfo.setNumberOfMIPs(1);
        metaInfo.setMipSolveTime(solution.getSolveTime());
        return new Allocation(bidderAllocationMap, (BundleValueBids)new BundleExactValueBids(), metaInfo);
    }

    @Override
    public ModelMIP copyOf() {
        return new SRVM_MIP(this.bidderPartialMips.keySet());
    }

    @Override
    protected Collection<Collection<Variable>> getVariablesOfInterest() {
        HashSet<Collection<Variable>> variablesOfInterest = new HashSet<Collection<Variable>>();
        for (SRVMBidder bidder : this.bidderPartialMips.keySet()) {
            for (SRVMBand band : this.world.getBands()) {
                variablesOfInterest.add(Sets.newHashSet((Object[])new Variable[]{this.worldPartialMip.getXVariable(bidder, band)}));
            }
        }
        return variablesOfInterest;
    }

    public SRVMWorldPartialMip getWorldPartialMip() {
        return this.worldPartialMip;
    }

    public Map<SRVMBidder, SRVMBidderPartialMIP> getBidderPartialMips() {
        return this.bidderPartialMips;
    }
}

