/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.clt;

import java.io.IOException;
import joptsimple.OptionSet;
import org.spectrumauctions.sats.clt.Model;
import org.spectrumauctions.sats.clt.ModelOptionParser;
import org.spectrumauctions.sats.core.api.CATSRegionsModelCreator;
import org.spectrumauctions.sats.core.api.IllegalConfigException;
import org.spectrumauctions.sats.core.api.PathResult;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;

public class CATSModelOptionParser
extends ModelOptionParser {
    public static final String KEY_NUMBIDDERS = "bidders";
    public static final String KEY_NUMGOODS = "goods";

    public CATSModelOptionParser() {
        this.accepts(KEY_NUMBIDDERS, "The number of bidders in CATS").withRequiredArg().ofType(Integer.class);
        this.accepts(KEY_NUMGOODS, "The number of goods in CATS").withRequiredArg().ofType(Integer.class);
    }

    @Override
    protected Model getModel() {
        return Model.CATS;
    }

    @Override
    public PathResult treatResult(String[] args) throws IllegalConfigException, UnsupportedBiddingLanguageException, IOException {
        CATSRegionsModelCreator.Builder builder = new CATSRegionsModelCreator.Builder();
        OptionSet options = this.parse(args);
        if (options.has(KEY_NUMBIDDERS)) {
            builder.setNumberOfBidders((Integer)options.valueOf(KEY_NUMBIDDERS));
        }
        if (options.has(KEY_NUMGOODS)) {
            builder.setNumberOfGoods((Integer)options.valueOf(KEY_NUMGOODS));
        }
        return this.allModelsResultTreating(options, builder);
    }
}

