/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.api;

import org.spectrumauctions.sats.core.api.IllegalConfigException;
import org.spectrumauctions.sats.core.bidlang.BiddingLanguage;
import org.spectrumauctions.sats.core.bidlang.generic.BidderSpecificGeneric;
import org.spectrumauctions.sats.core.bidlang.generic.SimpleRandomOrder.XORQRandomOrderSimple;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetDecreasing;
import org.spectrumauctions.sats.core.bidlang.generic.SizeOrderedPowerset.GenericPowersetIncreasing;
import org.spectrumauctions.sats.core.bidlang.xor.BidderSpecificXOR;
import org.spectrumauctions.sats.core.bidlang.xor.CatsXOR;
import org.spectrumauctions.sats.core.bidlang.xor.DecreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.IncreasingSizeOrderedXOR;
import org.spectrumauctions.sats.core.bidlang.xor.SizeBasedUniqueRandomXOR;

public enum BiddingLanguageEnum {
    SIZE_INCREASING,
    SIZE_DECREASING,
    RANDOM,
    BIDDER_SPECIFIC,
    CATS_SPECIFIC;


    public static Class<? extends BiddingLanguage> getXORLanguage(BiddingLanguageEnum type) throws IllegalConfigException {
        if (type == SIZE_INCREASING) {
            return IncreasingSizeOrderedXOR.class;
        }
        if (type == SIZE_DECREASING) {
            return DecreasingSizeOrderedXOR.class;
        }
        if (type == RANDOM) {
            return SizeBasedUniqueRandomXOR.class;
        }
        if (type == BIDDER_SPECIFIC) {
            return BidderSpecificXOR.class;
        }
        if (type == CATS_SPECIFIC) {
            return CatsXOR.class;
        }
        if (type == null) {
            throw new IllegalArgumentException("Language must not be null");
        }
        throw new IllegalConfigException("Illegal Language: " + type);
    }

    public static Class<? extends BiddingLanguage> getXORQLanguage(BiddingLanguageEnum type) throws IllegalConfigException {
        if (type == SIZE_INCREASING) {
            return GenericPowersetIncreasing.class;
        }
        if (type == SIZE_DECREASING) {
            return GenericPowersetDecreasing.class;
        }
        if (type == RANDOM) {
            return XORQRandomOrderSimple.class;
        }
        if (type == BIDDER_SPECIFIC) {
            return BidderSpecificGeneric.class;
        }
        if (type == null) {
            throw new IllegalArgumentException("Language must not be null");
        }
        throw new IllegalConfigException("Illegal Language: " + type);
    }
}

