/*
 * Decompiled with CFR 0.152.
 */
package org.spectrumauctions.sats.core.api;

import java.io.File;
import java.io.IOException;
import org.spectrumauctions.sats.core.api.IllegalConfigException;
import org.spectrumauctions.sats.core.api.ModelCreator;
import org.spectrumauctions.sats.core.api.PathResult;
import org.spectrumauctions.sats.core.model.UnsupportedBiddingLanguageException;
import org.spectrumauctions.sats.core.model.mrvm.MRVMLocalBidderSetup;
import org.spectrumauctions.sats.core.model.mrvm.MRVMNationalBidderSetup;
import org.spectrumauctions.sats.core.model.mrvm.MRVMRegionalBidderSetup;
import org.spectrumauctions.sats.core.model.mrvm.MultiRegionModel;

public class MRVMModelCreator
extends ModelCreator {
    private final int numberOfLocalBidders;
    private final int numberOfNationalBidders;
    private final int numberOfRegionalBidders;

    private MRVMModelCreator(Builder builder) {
        super(builder);
        this.numberOfNationalBidders = builder.numberOfNationalBidders;
        this.numberOfLocalBidders = builder.numberOfLocalBidders;
        this.numberOfRegionalBidders = builder.numberOfRegionalBidders;
    }

    @Override
    public PathResult generateResult(File outputFolder) throws UnsupportedBiddingLanguageException, IOException, IllegalConfigException {
        MultiRegionModel model = new MultiRegionModel();
        model.setNumberOfNationalBidders(this.numberOfNationalBidders);
        model.setNumberOfLocalBidders(this.numberOfLocalBidders);
        model.setNumberOfRegionalBidders(this.numberOfRegionalBidders);
        return this.appendTopLevelParamsAndSolve(model, outputFolder);
    }

    public static class Builder
    extends ModelCreator.Builder {
        private int numberOfLocalBidders = new MRVMLocalBidderSetup.Builder().getNumberOfBidders();
        private int numberOfNationalBidders = new MRVMNationalBidderSetup.Builder().getNumberOfBidders();
        private int numberOfRegionalBidders = new MRVMRegionalBidderSetup.Builder().getNumberOfBidders();

        @Override
        public MRVMModelCreator build() {
            return new MRVMModelCreator(this);
        }

        public int getNumberOfLocalBidders() {
            return this.numberOfLocalBidders;
        }

        public void setNumberOfLocalBidders(int numberOfLocalBidders) {
            this.numberOfLocalBidders = numberOfLocalBidders;
        }

        public int getNumberOfNationalBidders() {
            return this.numberOfNationalBidders;
        }

        public void setNumberOfNationalBidders(int numberOfNationalBidders) {
            this.numberOfNationalBidders = numberOfNationalBidders;
        }

        public int getNumberOfRegionalBidders() {
            return this.numberOfRegionalBidders;
        }

        public void setNumberOfRegionalBidders(int numberOfRegionalBidders) {
            this.numberOfRegionalBidders = numberOfRegionalBidders;
        }
    }
}

